/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationinsights;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.applicationinsights.AmazonApplicationInsightsAsync;
import com.amazonaws.services.applicationinsights.AmazonApplicationInsightsAsyncClientBuilder;
import com.amazonaws.services.applicationinsights.AmazonApplicationInsightsClient;
import com.amazonaws.services.applicationinsights.model.CreateApplicationRequest;
import com.amazonaws.services.applicationinsights.model.CreateApplicationResult;
import com.amazonaws.services.applicationinsights.model.CreateComponentRequest;
import com.amazonaws.services.applicationinsights.model.CreateComponentResult;
import com.amazonaws.services.applicationinsights.model.DeleteApplicationRequest;
import com.amazonaws.services.applicationinsights.model.DeleteApplicationResult;
import com.amazonaws.services.applicationinsights.model.DeleteComponentRequest;
import com.amazonaws.services.applicationinsights.model.DeleteComponentResult;
import com.amazonaws.services.applicationinsights.model.DescribeApplicationRequest;
import com.amazonaws.services.applicationinsights.model.DescribeApplicationResult;
import com.amazonaws.services.applicationinsights.model.DescribeComponentConfigurationRecommendationRequest;
import com.amazonaws.services.applicationinsights.model.DescribeComponentConfigurationRecommendationResult;
import com.amazonaws.services.applicationinsights.model.DescribeComponentConfigurationRequest;
import com.amazonaws.services.applicationinsights.model.DescribeComponentConfigurationResult;
import com.amazonaws.services.applicationinsights.model.DescribeComponentRequest;
import com.amazonaws.services.applicationinsights.model.DescribeComponentResult;
import com.amazonaws.services.applicationinsights.model.DescribeObservationRequest;
import com.amazonaws.services.applicationinsights.model.DescribeObservationResult;
import com.amazonaws.services.applicationinsights.model.DescribeProblemObservationsRequest;
import com.amazonaws.services.applicationinsights.model.DescribeProblemObservationsResult;
import com.amazonaws.services.applicationinsights.model.DescribeProblemRequest;
import com.amazonaws.services.applicationinsights.model.DescribeProblemResult;
import com.amazonaws.services.applicationinsights.model.ListApplicationsRequest;
import com.amazonaws.services.applicationinsights.model.ListApplicationsResult;
import com.amazonaws.services.applicationinsights.model.ListComponentsRequest;
import com.amazonaws.services.applicationinsights.model.ListComponentsResult;
import com.amazonaws.services.applicationinsights.model.ListProblemsRequest;
import com.amazonaws.services.applicationinsights.model.ListProblemsResult;
import com.amazonaws.services.applicationinsights.model.UpdateComponentConfigurationRequest;
import com.amazonaws.services.applicationinsights.model.UpdateComponentConfigurationResult;
import com.amazonaws.services.applicationinsights.model.UpdateComponentRequest;
import com.amazonaws.services.applicationinsights.model.UpdateComponentResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonApplicationInsightsAsyncClient
extends AmazonApplicationInsightsClient
implements AmazonApplicationInsightsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonApplicationInsightsAsyncClientBuilder asyncBuilder() {
        return AmazonApplicationInsightsAsyncClientBuilder.standard();
    }

    AmazonApplicationInsightsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateApplicationResult> createApplicationAsync(CreateApplicationRequest request) {
        return this.createApplicationAsync(request, null);
    }

    @Override
    public Future<CreateApplicationResult> createApplicationAsync(CreateApplicationRequest request, final AsyncHandler<CreateApplicationRequest, CreateApplicationResult> asyncHandler) {
        final CreateApplicationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateApplicationResult>(){

            @Override
            public CreateApplicationResult call() throws Exception {
                CreateApplicationResult result = null;
                try {
                    result = AmazonApplicationInsightsAsyncClient.this.executeCreateApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateComponentResult> createComponentAsync(CreateComponentRequest request) {
        return this.createComponentAsync(request, null);
    }

    @Override
    public Future<CreateComponentResult> createComponentAsync(CreateComponentRequest request, final AsyncHandler<CreateComponentRequest, CreateComponentResult> asyncHandler) {
        final CreateComponentRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateComponentResult>(){

            @Override
            public CreateComponentResult call() throws Exception {
                CreateComponentResult result = null;
                try {
                    result = AmazonApplicationInsightsAsyncClient.this.executeCreateComponent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteApplicationResult> deleteApplicationAsync(DeleteApplicationRequest request) {
        return this.deleteApplicationAsync(request, null);
    }

    @Override
    public Future<DeleteApplicationResult> deleteApplicationAsync(DeleteApplicationRequest request, final AsyncHandler<DeleteApplicationRequest, DeleteApplicationResult> asyncHandler) {
        final DeleteApplicationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteApplicationResult>(){

            @Override
            public DeleteApplicationResult call() throws Exception {
                DeleteApplicationResult result = null;
                try {
                    result = AmazonApplicationInsightsAsyncClient.this.executeDeleteApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteComponentResult> deleteComponentAsync(DeleteComponentRequest request) {
        return this.deleteComponentAsync(request, null);
    }

    @Override
    public Future<DeleteComponentResult> deleteComponentAsync(DeleteComponentRequest request, final AsyncHandler<DeleteComponentRequest, DeleteComponentResult> asyncHandler) {
        final DeleteComponentRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteComponentResult>(){

            @Override
            public DeleteComponentResult call() throws Exception {
                DeleteComponentResult result = null;
                try {
                    result = AmazonApplicationInsightsAsyncClient.this.executeDeleteComponent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeApplicationResult> describeApplicationAsync(DescribeApplicationRequest request) {
        return this.describeApplicationAsync(request, null);
    }

    @Override
    public Future<DescribeApplicationResult> describeApplicationAsync(DescribeApplicationRequest request, final AsyncHandler<DescribeApplicationRequest, DescribeApplicationResult> asyncHandler) {
        final DescribeApplicationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeApplicationResult>(){

            @Override
            public DescribeApplicationResult call() throws Exception {
                DescribeApplicationResult result = null;
                try {
                    result = AmazonApplicationInsightsAsyncClient.this.executeDescribeApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeComponentResult> describeComponentAsync(DescribeComponentRequest request) {
        return this.describeComponentAsync(request, null);
    }

    @Override
    public Future<DescribeComponentResult> describeComponentAsync(DescribeComponentRequest request, final AsyncHandler<DescribeComponentRequest, DescribeComponentResult> asyncHandler) {
        final DescribeComponentRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeComponentResult>(){

            @Override
            public DescribeComponentResult call() throws Exception {
                DescribeComponentResult result = null;
                try {
                    result = AmazonApplicationInsightsAsyncClient.this.executeDescribeComponent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeComponentConfigurationResult> describeComponentConfigurationAsync(DescribeComponentConfigurationRequest request) {
        return this.describeComponentConfigurationAsync(request, null);
    }

    @Override
    public Future<DescribeComponentConfigurationResult> describeComponentConfigurationAsync(DescribeComponentConfigurationRequest request, final AsyncHandler<DescribeComponentConfigurationRequest, DescribeComponentConfigurationResult> asyncHandler) {
        final DescribeComponentConfigurationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeComponentConfigurationResult>(){

            @Override
            public DescribeComponentConfigurationResult call() throws Exception {
                DescribeComponentConfigurationResult result = null;
                try {
                    result = AmazonApplicationInsightsAsyncClient.this.executeDescribeComponentConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeComponentConfigurationRecommendationResult> describeComponentConfigurationRecommendationAsync(DescribeComponentConfigurationRecommendationRequest request) {
        return this.describeComponentConfigurationRecommendationAsync(request, null);
    }

    @Override
    public Future<DescribeComponentConfigurationRecommendationResult> describeComponentConfigurationRecommendationAsync(DescribeComponentConfigurationRecommendationRequest request, final AsyncHandler<DescribeComponentConfigurationRecommendationRequest, DescribeComponentConfigurationRecommendationResult> asyncHandler) {
        final DescribeComponentConfigurationRecommendationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeComponentConfigurationRecommendationResult>(){

            @Override
            public DescribeComponentConfigurationRecommendationResult call() throws Exception {
                DescribeComponentConfigurationRecommendationResult result = null;
                try {
                    result = AmazonApplicationInsightsAsyncClient.this.executeDescribeComponentConfigurationRecommendation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeObservationResult> describeObservationAsync(DescribeObservationRequest request) {
        return this.describeObservationAsync(request, null);
    }

    @Override
    public Future<DescribeObservationResult> describeObservationAsync(DescribeObservationRequest request, final AsyncHandler<DescribeObservationRequest, DescribeObservationResult> asyncHandler) {
        final DescribeObservationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeObservationResult>(){

            @Override
            public DescribeObservationResult call() throws Exception {
                DescribeObservationResult result = null;
                try {
                    result = AmazonApplicationInsightsAsyncClient.this.executeDescribeObservation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeProblemResult> describeProblemAsync(DescribeProblemRequest request) {
        return this.describeProblemAsync(request, null);
    }

    @Override
    public Future<DescribeProblemResult> describeProblemAsync(DescribeProblemRequest request, final AsyncHandler<DescribeProblemRequest, DescribeProblemResult> asyncHandler) {
        final DescribeProblemRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeProblemResult>(){

            @Override
            public DescribeProblemResult call() throws Exception {
                DescribeProblemResult result = null;
                try {
                    result = AmazonApplicationInsightsAsyncClient.this.executeDescribeProblem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeProblemObservationsResult> describeProblemObservationsAsync(DescribeProblemObservationsRequest request) {
        return this.describeProblemObservationsAsync(request, null);
    }

    @Override
    public Future<DescribeProblemObservationsResult> describeProblemObservationsAsync(DescribeProblemObservationsRequest request, final AsyncHandler<DescribeProblemObservationsRequest, DescribeProblemObservationsResult> asyncHandler) {
        final DescribeProblemObservationsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeProblemObservationsResult>(){

            @Override
            public DescribeProblemObservationsResult call() throws Exception {
                DescribeProblemObservationsResult result = null;
                try {
                    result = AmazonApplicationInsightsAsyncClient.this.executeDescribeProblemObservations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListApplicationsResult> listApplicationsAsync(ListApplicationsRequest request) {
        return this.listApplicationsAsync(request, null);
    }

    @Override
    public Future<ListApplicationsResult> listApplicationsAsync(ListApplicationsRequest request, final AsyncHandler<ListApplicationsRequest, ListApplicationsResult> asyncHandler) {
        final ListApplicationsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListApplicationsResult>(){

            @Override
            public ListApplicationsResult call() throws Exception {
                ListApplicationsResult result = null;
                try {
                    result = AmazonApplicationInsightsAsyncClient.this.executeListApplications(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListComponentsResult> listComponentsAsync(ListComponentsRequest request) {
        return this.listComponentsAsync(request, null);
    }

    @Override
    public Future<ListComponentsResult> listComponentsAsync(ListComponentsRequest request, final AsyncHandler<ListComponentsRequest, ListComponentsResult> asyncHandler) {
        final ListComponentsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListComponentsResult>(){

            @Override
            public ListComponentsResult call() throws Exception {
                ListComponentsResult result = null;
                try {
                    result = AmazonApplicationInsightsAsyncClient.this.executeListComponents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListProblemsResult> listProblemsAsync(ListProblemsRequest request) {
        return this.listProblemsAsync(request, null);
    }

    @Override
    public Future<ListProblemsResult> listProblemsAsync(ListProblemsRequest request, final AsyncHandler<ListProblemsRequest, ListProblemsResult> asyncHandler) {
        final ListProblemsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListProblemsResult>(){

            @Override
            public ListProblemsResult call() throws Exception {
                ListProblemsResult result = null;
                try {
                    result = AmazonApplicationInsightsAsyncClient.this.executeListProblems(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateComponentResult> updateComponentAsync(UpdateComponentRequest request) {
        return this.updateComponentAsync(request, null);
    }

    @Override
    public Future<UpdateComponentResult> updateComponentAsync(UpdateComponentRequest request, final AsyncHandler<UpdateComponentRequest, UpdateComponentResult> asyncHandler) {
        final UpdateComponentRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateComponentResult>(){

            @Override
            public UpdateComponentResult call() throws Exception {
                UpdateComponentResult result = null;
                try {
                    result = AmazonApplicationInsightsAsyncClient.this.executeUpdateComponent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateComponentConfigurationResult> updateComponentConfigurationAsync(UpdateComponentConfigurationRequest request) {
        return this.updateComponentConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateComponentConfigurationResult> updateComponentConfigurationAsync(UpdateComponentConfigurationRequest request, final AsyncHandler<UpdateComponentConfigurationRequest, UpdateComponentConfigurationResult> asyncHandler) {
        final UpdateComponentConfigurationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateComponentConfigurationResult>(){

            @Override
            public UpdateComponentConfigurationResult call() throws Exception {
                UpdateComponentConfigurationResult result = null;
                try {
                    result = AmazonApplicationInsightsAsyncClient.this.executeUpdateComponentConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

