/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.amplify.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.amplify.model.ProductionBranch;
import java.util.Date;

@SdkInternalApi
public class ProductionBranchMarshaller {
    private static final MarshallingInfo<Date> LASTDEPLOYTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastDeployTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> THUMBNAILURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thumbnailUrl").build();
    private static final MarshallingInfo<String> BRANCHNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("branchName").build();
    private static final ProductionBranchMarshaller instance = new ProductionBranchMarshaller();

    public static ProductionBranchMarshaller getInstance() {
        return instance;
    }

    public void marshall(ProductionBranch productionBranch, ProtocolMarshaller protocolMarshaller) {
        if (productionBranch == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(productionBranch.getLastDeployTime(), LASTDEPLOYTIME_BINDING);
            protocolMarshaller.marshall(productionBranch.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(productionBranch.getThumbnailUrl(), THUMBNAILURL_BINDING);
            protocolMarshaller.marshall(productionBranch.getBranchName(), BRANCHNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

