/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.amplify.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.amplify.model.JobSummary;
import com.amazonaws.services.amplify.model.Step;
import com.amazonaws.services.amplify.model.transform.JobMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Job
implements Serializable,
Cloneable,
StructuredPojo {
    private JobSummary summary;
    private List<Step> steps;

    public void setSummary(JobSummary summary) {
        this.summary = summary;
    }

    public JobSummary getSummary() {
        return this.summary;
    }

    public Job withSummary(JobSummary summary) {
        this.setSummary(summary);
        return this;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void setSteps(Collection<Step> steps) {
        if (steps == null) {
            this.steps = null;
            return;
        }
        this.steps = new ArrayList<Step>(steps);
    }

    public Job withSteps(Step ... steps) {
        if (this.steps == null) {
            this.setSteps(new ArrayList<Step>(steps.length));
        }
        for (Step ele : steps) {
            this.steps.add(ele);
        }
        return this;
    }

    public Job withSteps(Collection<Step> steps) {
        this.setSteps(steps);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSummary() != null) {
            sb.append("Summary: ").append(this.getSummary()).append(",");
        }
        if (this.getSteps() != null) {
            sb.append("Steps: ").append(this.getSteps());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job)obj;
        if (other.getSummary() == null ^ this.getSummary() == null) {
            return false;
        }
        if (other.getSummary() != null && !other.getSummary().equals(this.getSummary())) {
            return false;
        }
        if (other.getSteps() == null ^ this.getSteps() == null) {
            return false;
        }
        return other.getSteps() == null || other.getSteps().equals(this.getSteps());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSummary() == null ? 0 : this.getSummary().hashCode());
        hashCode = 31 * hashCode + (this.getSteps() == null ? 0 : this.getSteps().hashCode());
        return hashCode;
    }

    public Job clone() {
        try {
            return (Job)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

