/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.alexaforbusiness.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.alexaforbusiness.model.SmartHomeAppliance;

@SdkInternalApi
public class SmartHomeApplianceMarshaller {
    private static final MarshallingInfo<String> FRIENDLYNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FriendlyName").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> MANUFACTURERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ManufacturerName").build();
    private static final SmartHomeApplianceMarshaller instance = new SmartHomeApplianceMarshaller();

    public static SmartHomeApplianceMarshaller getInstance() {
        return instance;
    }

    public void marshall(SmartHomeAppliance smartHomeAppliance, ProtocolMarshaller protocolMarshaller) {
        if (smartHomeAppliance == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(smartHomeAppliance.getFriendlyName(), FRIENDLYNAME_BINDING);
            protocolMarshaller.marshall(smartHomeAppliance.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(smartHomeAppliance.getManufacturerName(), MANUFACTURERNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

