/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.alexaforbusiness.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.alexaforbusiness.model.ContactData;
import java.util.List;

@SdkInternalApi
public class ContactDataMarshaller {
    private static final MarshallingInfo<String> CONTACTARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContactArn").build();
    private static final MarshallingInfo<String> DISPLAYNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisplayName").build();
    private static final MarshallingInfo<String> FIRSTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FirstName").build();
    private static final MarshallingInfo<String> LASTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastName").build();
    private static final MarshallingInfo<String> PHONENUMBER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PhoneNumber").build();
    private static final MarshallingInfo<List> PHONENUMBERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PhoneNumbers").build();
    private static final MarshallingInfo<List> SIPADDRESSES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SipAddresses").build();
    private static final ContactDataMarshaller instance = new ContactDataMarshaller();

    public static ContactDataMarshaller getInstance() {
        return instance;
    }

    public void marshall(ContactData contactData, ProtocolMarshaller protocolMarshaller) {
        if (contactData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(contactData.getContactArn(), CONTACTARN_BINDING);
            protocolMarshaller.marshall(contactData.getDisplayName(), DISPLAYNAME_BINDING);
            protocolMarshaller.marshall(contactData.getFirstName(), FIRSTNAME_BINDING);
            protocolMarshaller.marshall(contactData.getLastName(), LASTNAME_BINDING);
            protocolMarshaller.marshall(contactData.getPhoneNumber(), PHONENUMBER_BINDING);
            protocolMarshaller.marshall(contactData.getPhoneNumbers(), PHONENUMBERS_BINDING);
            protocolMarshaller.marshall(contactData.getSipAddresses(), SIPADDRESSES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

