/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.alexaforbusiness.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.alexaforbusiness.model.BusinessReport;
import java.util.Date;

@SdkInternalApi
public class BusinessReportMarshaller {
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> FAILURECODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureCode").build();
    private static final MarshallingInfo<StructuredPojo> S3LOCATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Location").build();
    private static final MarshallingInfo<Date> DELIVERYTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> DOWNLOADURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DownloadUrl").build();
    private static final BusinessReportMarshaller instance = new BusinessReportMarshaller();

    public static BusinessReportMarshaller getInstance() {
        return instance;
    }

    public void marshall(BusinessReport businessReport, ProtocolMarshaller protocolMarshaller) {
        if (businessReport == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(businessReport.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(businessReport.getFailureCode(), FAILURECODE_BINDING);
            protocolMarshaller.marshall(businessReport.getS3Location(), S3LOCATION_BINDING);
            protocolMarshaller.marshall(businessReport.getDeliveryTime(), DELIVERYTIME_BINDING);
            protocolMarshaller.marshall(businessReport.getDownloadUrl(), DOWNLOADURL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

