/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.acmpca.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.acmpca.model.ActionType;
import com.amazonaws.services.acmpca.model.transform.PermissionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Permission
implements Serializable,
Cloneable,
StructuredPojo {
    private String certificateAuthorityArn;
    private Date createdAt;
    private String principal;
    private String sourceAccount;
    private List<String> actions;
    private String policy;

    public void setCertificateAuthorityArn(String certificateAuthorityArn) {
        this.certificateAuthorityArn = certificateAuthorityArn;
    }

    public String getCertificateAuthorityArn() {
        return this.certificateAuthorityArn;
    }

    public Permission withCertificateAuthorityArn(String certificateAuthorityArn) {
        this.setCertificateAuthorityArn(certificateAuthorityArn);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Permission withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public Permission withPrincipal(String principal) {
        this.setPrincipal(principal);
        return this;
    }

    public void setSourceAccount(String sourceAccount) {
        this.sourceAccount = sourceAccount;
    }

    public String getSourceAccount() {
        return this.sourceAccount;
    }

    public Permission withSourceAccount(String sourceAccount) {
        this.setSourceAccount(sourceAccount);
        return this;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(Collection<String> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<String>(actions);
    }

    public Permission withActions(String ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<String>(actions.length));
        }
        for (String ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public Permission withActions(Collection<String> actions) {
        this.setActions(actions);
        return this;
    }

    public Permission withActions(ActionType ... actions) {
        ArrayList<String> actionsCopy = new ArrayList<String>(actions.length);
        for (ActionType value : actions) {
            actionsCopy.add(value.toString());
        }
        if (this.getActions() == null) {
            this.setActions(actionsCopy);
        } else {
            this.getActions().addAll(actionsCopy);
        }
        return this;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public String getPolicy() {
        return this.policy;
    }

    public Permission withPolicy(String policy) {
        this.setPolicy(policy);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCertificateAuthorityArn() != null) {
            sb.append("CertificateAuthorityArn: ").append(this.getCertificateAuthorityArn()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getPrincipal() != null) {
            sb.append("Principal: ").append(this.getPrincipal()).append(",");
        }
        if (this.getSourceAccount() != null) {
            sb.append("SourceAccount: ").append(this.getSourceAccount()).append(",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions()).append(",");
        }
        if (this.getPolicy() != null) {
            sb.append("Policy: ").append(this.getPolicy());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Permission)) {
            return false;
        }
        Permission other = (Permission)obj;
        if (other.getCertificateAuthorityArn() == null ^ this.getCertificateAuthorityArn() == null) {
            return false;
        }
        if (other.getCertificateAuthorityArn() != null && !other.getCertificateAuthorityArn().equals(this.getCertificateAuthorityArn())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getPrincipal() == null ^ this.getPrincipal() == null) {
            return false;
        }
        if (other.getPrincipal() != null && !other.getPrincipal().equals(this.getPrincipal())) {
            return false;
        }
        if (other.getSourceAccount() == null ^ this.getSourceAccount() == null) {
            return false;
        }
        if (other.getSourceAccount() != null && !other.getSourceAccount().equals(this.getSourceAccount())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.getPolicy() == null ^ this.getPolicy() == null) {
            return false;
        }
        return other.getPolicy() == null || other.getPolicy().equals(this.getPolicy());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCertificateAuthorityArn() == null ? 0 : this.getCertificateAuthorityArn().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getPrincipal() == null ? 0 : this.getPrincipal().hashCode());
        hashCode = 31 * hashCode + (this.getSourceAccount() == null ? 0 : this.getSourceAccount().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.getPolicy() == null ? 0 : this.getPolicy().hashCode());
        return hashCode;
    }

    public Permission clone() {
        try {
            return (Permission)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PermissionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

