/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workmail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.workmail.model.PermissionType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutMailboxPermissionsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String organizationId;
    private String entityId;
    private String granteeId;
    private List<String> permissionValues;

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public PutMailboxPermissionsRequest withOrganizationId(String organizationId) {
        this.setOrganizationId(organizationId);
        return this;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public PutMailboxPermissionsRequest withEntityId(String entityId) {
        this.setEntityId(entityId);
        return this;
    }

    public void setGranteeId(String granteeId) {
        this.granteeId = granteeId;
    }

    public String getGranteeId() {
        return this.granteeId;
    }

    public PutMailboxPermissionsRequest withGranteeId(String granteeId) {
        this.setGranteeId(granteeId);
        return this;
    }

    public List<String> getPermissionValues() {
        return this.permissionValues;
    }

    public void setPermissionValues(Collection<String> permissionValues) {
        if (permissionValues == null) {
            this.permissionValues = null;
            return;
        }
        this.permissionValues = new ArrayList<String>(permissionValues);
    }

    public PutMailboxPermissionsRequest withPermissionValues(String ... permissionValues) {
        if (this.permissionValues == null) {
            this.setPermissionValues(new ArrayList<String>(permissionValues.length));
        }
        for (String ele : permissionValues) {
            this.permissionValues.add(ele);
        }
        return this;
    }

    public PutMailboxPermissionsRequest withPermissionValues(Collection<String> permissionValues) {
        this.setPermissionValues(permissionValues);
        return this;
    }

    public PutMailboxPermissionsRequest withPermissionValues(PermissionType ... permissionValues) {
        ArrayList<String> permissionValuesCopy = new ArrayList<String>(permissionValues.length);
        for (PermissionType value : permissionValues) {
            permissionValuesCopy.add(value.toString());
        }
        if (this.getPermissionValues() == null) {
            this.setPermissionValues(permissionValuesCopy);
        } else {
            this.getPermissionValues().addAll(permissionValuesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOrganizationId() != null) {
            sb.append("OrganizationId: ").append(this.getOrganizationId()).append(",");
        }
        if (this.getEntityId() != null) {
            sb.append("EntityId: ").append(this.getEntityId()).append(",");
        }
        if (this.getGranteeId() != null) {
            sb.append("GranteeId: ").append(this.getGranteeId()).append(",");
        }
        if (this.getPermissionValues() != null) {
            sb.append("PermissionValues: ").append(this.getPermissionValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMailboxPermissionsRequest)) {
            return false;
        }
        PutMailboxPermissionsRequest other = (PutMailboxPermissionsRequest)obj;
        if (other.getOrganizationId() == null ^ this.getOrganizationId() == null) {
            return false;
        }
        if (other.getOrganizationId() != null && !other.getOrganizationId().equals(this.getOrganizationId())) {
            return false;
        }
        if (other.getEntityId() == null ^ this.getEntityId() == null) {
            return false;
        }
        if (other.getEntityId() != null && !other.getEntityId().equals(this.getEntityId())) {
            return false;
        }
        if (other.getGranteeId() == null ^ this.getGranteeId() == null) {
            return false;
        }
        if (other.getGranteeId() != null && !other.getGranteeId().equals(this.getGranteeId())) {
            return false;
        }
        if (other.getPermissionValues() == null ^ this.getPermissionValues() == null) {
            return false;
        }
        return other.getPermissionValues() == null || other.getPermissionValues().equals(this.getPermissionValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOrganizationId() == null ? 0 : this.getOrganizationId().hashCode());
        hashCode = 31 * hashCode + (this.getEntityId() == null ? 0 : this.getEntityId().hashCode());
        hashCode = 31 * hashCode + (this.getGranteeId() == null ? 0 : this.getGranteeId().hashCode());
        hashCode = 31 * hashCode + (this.getPermissionValues() == null ? 0 : this.getPermissionValues().hashCode());
        return hashCode;
    }

    @Override
    public PutMailboxPermissionsRequest clone() {
        return (PutMailboxPermissionsRequest)super.clone();
    }
}

