/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workmail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.workmail.model.MemberType;
import com.amazonaws.services.workmail.model.PermissionType;
import com.amazonaws.services.workmail.model.transform.PermissionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Permission
implements Serializable,
Cloneable,
StructuredPojo {
    private String granteeId;
    private String granteeType;
    private List<String> permissionValues;

    public void setGranteeId(String granteeId) {
        this.granteeId = granteeId;
    }

    public String getGranteeId() {
        return this.granteeId;
    }

    public Permission withGranteeId(String granteeId) {
        this.setGranteeId(granteeId);
        return this;
    }

    public void setGranteeType(String granteeType) {
        this.granteeType = granteeType;
    }

    public String getGranteeType() {
        return this.granteeType;
    }

    public Permission withGranteeType(String granteeType) {
        this.setGranteeType(granteeType);
        return this;
    }

    public Permission withGranteeType(MemberType granteeType) {
        this.granteeType = granteeType.toString();
        return this;
    }

    public List<String> getPermissionValues() {
        return this.permissionValues;
    }

    public void setPermissionValues(Collection<String> permissionValues) {
        if (permissionValues == null) {
            this.permissionValues = null;
            return;
        }
        this.permissionValues = new ArrayList<String>(permissionValues);
    }

    public Permission withPermissionValues(String ... permissionValues) {
        if (this.permissionValues == null) {
            this.setPermissionValues(new ArrayList<String>(permissionValues.length));
        }
        for (String ele : permissionValues) {
            this.permissionValues.add(ele);
        }
        return this;
    }

    public Permission withPermissionValues(Collection<String> permissionValues) {
        this.setPermissionValues(permissionValues);
        return this;
    }

    public Permission withPermissionValues(PermissionType ... permissionValues) {
        ArrayList<String> permissionValuesCopy = new ArrayList<String>(permissionValues.length);
        for (PermissionType value : permissionValues) {
            permissionValuesCopy.add(value.toString());
        }
        if (this.getPermissionValues() == null) {
            this.setPermissionValues(permissionValuesCopy);
        } else {
            this.getPermissionValues().addAll(permissionValuesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGranteeId() != null) {
            sb.append("GranteeId: ").append(this.getGranteeId()).append(",");
        }
        if (this.getGranteeType() != null) {
            sb.append("GranteeType: ").append(this.getGranteeType()).append(",");
        }
        if (this.getPermissionValues() != null) {
            sb.append("PermissionValues: ").append(this.getPermissionValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Permission)) {
            return false;
        }
        Permission other = (Permission)obj;
        if (other.getGranteeId() == null ^ this.getGranteeId() == null) {
            return false;
        }
        if (other.getGranteeId() != null && !other.getGranteeId().equals(this.getGranteeId())) {
            return false;
        }
        if (other.getGranteeType() == null ^ this.getGranteeType() == null) {
            return false;
        }
        if (other.getGranteeType() != null && !other.getGranteeType().equals(this.getGranteeType())) {
            return false;
        }
        if (other.getPermissionValues() == null ^ this.getPermissionValues() == null) {
            return false;
        }
        return other.getPermissionValues() == null || other.getPermissionValues().equals(this.getPermissionValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGranteeId() == null ? 0 : this.getGranteeId().hashCode());
        hashCode = 31 * hashCode + (this.getGranteeType() == null ? 0 : this.getGranteeType().hashCode());
        hashCode = 31 * hashCode + (this.getPermissionValues() == null ? 0 : this.getPermissionValues().hashCode());
        return hashCode;
    }

    public Permission clone() {
        try {
            return (Permission)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PermissionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

