/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.signer.waiters;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.signer.model.DescribeSigningJobResult;
import com.amazonaws.thirdparty.jackson.databind.JsonNode;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import java.io.IOException;

@SdkInternalApi
class SuccessfulSigningJob {
    SuccessfulSigningJob() {
    }

    static class IsResourceNotFoundExceptionMatcher
    extends WaiterAcceptor<DescribeSigningJobResult> {
        IsResourceNotFoundExceptionMatcher() {
        }

        @Override
        public boolean matches(AmazonServiceException e) {
            return "ResourceNotFoundException".equals(e.getErrorCode());
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }
    }

    static class IsFailedMatcher
    extends WaiterAcceptor<DescribeSigningJobResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsFailedMatcher() {
        }

        @Override
        public boolean matches(DescribeSigningJobResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"Failed\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("status");
        }
    }

    static class IsSucceededMatcher
    extends WaiterAcceptor<DescribeSigningJobResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsSucceededMatcher() {
        }

        @Override
        public boolean matches(DescribeSigningJobResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"Succeeded\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("status");
        }
    }
}

