/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.signer.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.signer.AWSsigner;
import com.amazonaws.services.signer.model.DescribeSigningJobRequest;
import com.amazonaws.services.signer.model.DescribeSigningJobResult;
import com.amazonaws.services.signer.waiters.DescribeSigningJobFunction;
import com.amazonaws.services.signer.waiters.SuccessfulSigningJob;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AWSsignerWaiters {
    private final AWSsigner client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AWSsignerWaiters(AWSsigner client) {
        this.client = client;
    }

    public Waiter<DescribeSigningJobRequest> successfulSigningJob() {
        return new WaiterBuilder<DescribeSigningJobRequest, DescribeSigningJobResult>().withSdkFunction(new DescribeSigningJobFunction(this.client)).withAcceptors(new SuccessfulSigningJob.IsSucceededMatcher(), new SuccessfulSigningJob.IsFailedMatcher(), new SuccessfulSigningJob.IsResourceNotFoundExceptionMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(25), new FixedDelayStrategy(20))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

