/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.signer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.signer.model.SigningPlatform;

@SdkInternalApi
public class SigningPlatformMarshaller {
    private static final MarshallingInfo<String> PLATFORMID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("platformId").build();
    private static final MarshallingInfo<String> DISPLAYNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("displayName").build();
    private static final MarshallingInfo<String> PARTNER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("partner").build();
    private static final MarshallingInfo<String> TARGET_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("target").build();
    private static final MarshallingInfo<String> CATEGORY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("category").build();
    private static final MarshallingInfo<StructuredPojo> SIGNINGCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("signingConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> SIGNINGIMAGEFORMAT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("signingImageFormat").build();
    private static final MarshallingInfo<Integer> MAXSIZEINMB_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxSizeInMB").build();
    private static final SigningPlatformMarshaller instance = new SigningPlatformMarshaller();

    public static SigningPlatformMarshaller getInstance() {
        return instance;
    }

    public void marshall(SigningPlatform signingPlatform, ProtocolMarshaller protocolMarshaller) {
        if (signingPlatform == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(signingPlatform.getPlatformId(), PLATFORMID_BINDING);
            protocolMarshaller.marshall(signingPlatform.getDisplayName(), DISPLAYNAME_BINDING);
            protocolMarshaller.marshall(signingPlatform.getPartner(), PARTNER_BINDING);
            protocolMarshaller.marshall(signingPlatform.getTarget(), TARGET_BINDING);
            protocolMarshaller.marshall(signingPlatform.getCategory(), CATEGORY_BINDING);
            protocolMarshaller.marshall(signingPlatform.getSigningConfiguration(), SIGNINGCONFIGURATION_BINDING);
            protocolMarshaller.marshall(signingPlatform.getSigningImageFormat(), SIGNINGIMAGEFORMAT_BINDING);
            protocolMarshaller.marshall(signingPlatform.getMaxSizeInMB(), MAXSIZEINMB_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

