/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.signer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.signer.model.SigningImageFormat;
import java.util.List;

@SdkInternalApi
public class SigningImageFormatMarshaller {
    private static final MarshallingInfo<List> SUPPORTEDFORMATS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportedFormats").build();
    private static final MarshallingInfo<String> DEFAULTFORMAT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("defaultFormat").build();
    private static final SigningImageFormatMarshaller instance = new SigningImageFormatMarshaller();

    public static SigningImageFormatMarshaller getInstance() {
        return instance;
    }

    public void marshall(SigningImageFormat signingImageFormat, ProtocolMarshaller protocolMarshaller) {
        if (signingImageFormat == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(signingImageFormat.getSupportedFormats(), SUPPORTEDFORMATS_BINDING);
            protocolMarshaller.marshall(signingImageFormat.getDefaultFormat(), DEFAULTFORMAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

