/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.signer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.signer.model.SigningConfiguration;

@SdkInternalApi
public class SigningConfigurationMarshaller {
    private static final MarshallingInfo<StructuredPojo> ENCRYPTIONALGORITHMOPTIONS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encryptionAlgorithmOptions").build();
    private static final MarshallingInfo<StructuredPojo> HASHALGORITHMOPTIONS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hashAlgorithmOptions").build();
    private static final SigningConfigurationMarshaller instance = new SigningConfigurationMarshaller();

    public static SigningConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(SigningConfiguration signingConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (signingConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(signingConfiguration.getEncryptionAlgorithmOptions(), ENCRYPTIONALGORITHMOPTIONS_BINDING);
            protocolMarshaller.marshall(signingConfiguration.getHashAlgorithmOptions(), HASHALGORITHMOPTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

