/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.signer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.signer.model.EncryptionAlgorithmOptions;
import com.amazonaws.services.signer.model.HashAlgorithmOptions;
import com.amazonaws.services.signer.model.transform.SigningConfigurationMarshaller;
import java.io.Serializable;

public class SigningConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private EncryptionAlgorithmOptions encryptionAlgorithmOptions;
    private HashAlgorithmOptions hashAlgorithmOptions;

    public void setEncryptionAlgorithmOptions(EncryptionAlgorithmOptions encryptionAlgorithmOptions) {
        this.encryptionAlgorithmOptions = encryptionAlgorithmOptions;
    }

    public EncryptionAlgorithmOptions getEncryptionAlgorithmOptions() {
        return this.encryptionAlgorithmOptions;
    }

    public SigningConfiguration withEncryptionAlgorithmOptions(EncryptionAlgorithmOptions encryptionAlgorithmOptions) {
        this.setEncryptionAlgorithmOptions(encryptionAlgorithmOptions);
        return this;
    }

    public void setHashAlgorithmOptions(HashAlgorithmOptions hashAlgorithmOptions) {
        this.hashAlgorithmOptions = hashAlgorithmOptions;
    }

    public HashAlgorithmOptions getHashAlgorithmOptions() {
        return this.hashAlgorithmOptions;
    }

    public SigningConfiguration withHashAlgorithmOptions(HashAlgorithmOptions hashAlgorithmOptions) {
        this.setHashAlgorithmOptions(hashAlgorithmOptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEncryptionAlgorithmOptions() != null) {
            sb.append("EncryptionAlgorithmOptions: ").append(this.getEncryptionAlgorithmOptions()).append(",");
        }
        if (this.getHashAlgorithmOptions() != null) {
            sb.append("HashAlgorithmOptions: ").append(this.getHashAlgorithmOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningConfiguration)) {
            return false;
        }
        SigningConfiguration other = (SigningConfiguration)obj;
        if (other.getEncryptionAlgorithmOptions() == null ^ this.getEncryptionAlgorithmOptions() == null) {
            return false;
        }
        if (other.getEncryptionAlgorithmOptions() != null && !other.getEncryptionAlgorithmOptions().equals(this.getEncryptionAlgorithmOptions())) {
            return false;
        }
        if (other.getHashAlgorithmOptions() == null ^ this.getHashAlgorithmOptions() == null) {
            return false;
        }
        return other.getHashAlgorithmOptions() == null || other.getHashAlgorithmOptions().equals(this.getHashAlgorithmOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEncryptionAlgorithmOptions() == null ? 0 : this.getEncryptionAlgorithmOptions().hashCode());
        hashCode = 31 * hashCode + (this.getHashAlgorithmOptions() == null ? 0 : this.getHashAlgorithmOptions().hashCode());
        return hashCode;
    }

    public SigningConfiguration clone() {
        try {
            return (SigningConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SigningConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

