/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.signer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.signer.model.EncryptionAlgorithm;
import com.amazonaws.services.signer.model.transform.EncryptionAlgorithmOptionsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EncryptionAlgorithmOptions
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> allowedValues;
    private String defaultValue;

    public List<String> getAllowedValues() {
        return this.allowedValues;
    }

    public void setAllowedValues(Collection<String> allowedValues) {
        if (allowedValues == null) {
            this.allowedValues = null;
            return;
        }
        this.allowedValues = new ArrayList<String>(allowedValues);
    }

    public EncryptionAlgorithmOptions withAllowedValues(String ... allowedValues) {
        if (this.allowedValues == null) {
            this.setAllowedValues(new ArrayList<String>(allowedValues.length));
        }
        for (String ele : allowedValues) {
            this.allowedValues.add(ele);
        }
        return this;
    }

    public EncryptionAlgorithmOptions withAllowedValues(Collection<String> allowedValues) {
        this.setAllowedValues(allowedValues);
        return this;
    }

    public EncryptionAlgorithmOptions withAllowedValues(EncryptionAlgorithm ... allowedValues) {
        ArrayList<String> allowedValuesCopy = new ArrayList<String>(allowedValues.length);
        for (EncryptionAlgorithm value : allowedValues) {
            allowedValuesCopy.add(value.toString());
        }
        if (this.getAllowedValues() == null) {
            this.setAllowedValues(allowedValuesCopy);
        } else {
            this.getAllowedValues().addAll(allowedValuesCopy);
        }
        return this;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public EncryptionAlgorithmOptions withDefaultValue(String defaultValue) {
        this.setDefaultValue(defaultValue);
        return this;
    }

    public EncryptionAlgorithmOptions withDefaultValue(EncryptionAlgorithm defaultValue) {
        this.defaultValue = defaultValue.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAllowedValues() != null) {
            sb.append("AllowedValues: ").append(this.getAllowedValues()).append(",");
        }
        if (this.getDefaultValue() != null) {
            sb.append("DefaultValue: ").append(this.getDefaultValue());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionAlgorithmOptions)) {
            return false;
        }
        EncryptionAlgorithmOptions other = (EncryptionAlgorithmOptions)obj;
        if (other.getAllowedValues() == null ^ this.getAllowedValues() == null) {
            return false;
        }
        if (other.getAllowedValues() != null && !other.getAllowedValues().equals(this.getAllowedValues())) {
            return false;
        }
        if (other.getDefaultValue() == null ^ this.getDefaultValue() == null) {
            return false;
        }
        return other.getDefaultValue() == null || other.getDefaultValue().equals(this.getDefaultValue());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAllowedValues() == null ? 0 : this.getAllowedValues().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultValue() == null ? 0 : this.getDefaultValue().hashCode());
        return hashCode;
    }

    public EncryptionAlgorithmOptions clone() {
        try {
            return (EncryptionAlgorithmOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EncryptionAlgorithmOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

