/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicediscovery;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.servicediscovery.AWSServiceDiscovery;
import com.amazonaws.services.servicediscovery.AWSServiceDiscoveryClientBuilder;
import com.amazonaws.services.servicediscovery.model.AWSServiceDiscoveryException;
import com.amazonaws.services.servicediscovery.model.CreatePrivateDnsNamespaceRequest;
import com.amazonaws.services.servicediscovery.model.CreatePrivateDnsNamespaceResult;
import com.amazonaws.services.servicediscovery.model.CreatePublicDnsNamespaceRequest;
import com.amazonaws.services.servicediscovery.model.CreatePublicDnsNamespaceResult;
import com.amazonaws.services.servicediscovery.model.CreateServiceRequest;
import com.amazonaws.services.servicediscovery.model.CreateServiceResult;
import com.amazonaws.services.servicediscovery.model.CustomHealthNotFoundException;
import com.amazonaws.services.servicediscovery.model.DeleteNamespaceRequest;
import com.amazonaws.services.servicediscovery.model.DeleteNamespaceResult;
import com.amazonaws.services.servicediscovery.model.DeleteServiceRequest;
import com.amazonaws.services.servicediscovery.model.DeleteServiceResult;
import com.amazonaws.services.servicediscovery.model.DeregisterInstanceRequest;
import com.amazonaws.services.servicediscovery.model.DeregisterInstanceResult;
import com.amazonaws.services.servicediscovery.model.DuplicateRequestException;
import com.amazonaws.services.servicediscovery.model.GetInstanceRequest;
import com.amazonaws.services.servicediscovery.model.GetInstanceResult;
import com.amazonaws.services.servicediscovery.model.GetInstancesHealthStatusRequest;
import com.amazonaws.services.servicediscovery.model.GetInstancesHealthStatusResult;
import com.amazonaws.services.servicediscovery.model.GetNamespaceRequest;
import com.amazonaws.services.servicediscovery.model.GetNamespaceResult;
import com.amazonaws.services.servicediscovery.model.GetOperationRequest;
import com.amazonaws.services.servicediscovery.model.GetOperationResult;
import com.amazonaws.services.servicediscovery.model.GetServiceRequest;
import com.amazonaws.services.servicediscovery.model.GetServiceResult;
import com.amazonaws.services.servicediscovery.model.InstanceNotFoundException;
import com.amazonaws.services.servicediscovery.model.InvalidInputException;
import com.amazonaws.services.servicediscovery.model.ListInstancesRequest;
import com.amazonaws.services.servicediscovery.model.ListInstancesResult;
import com.amazonaws.services.servicediscovery.model.ListNamespacesRequest;
import com.amazonaws.services.servicediscovery.model.ListNamespacesResult;
import com.amazonaws.services.servicediscovery.model.ListOperationsRequest;
import com.amazonaws.services.servicediscovery.model.ListOperationsResult;
import com.amazonaws.services.servicediscovery.model.ListServicesRequest;
import com.amazonaws.services.servicediscovery.model.ListServicesResult;
import com.amazonaws.services.servicediscovery.model.NamespaceAlreadyExistsException;
import com.amazonaws.services.servicediscovery.model.NamespaceNotFoundException;
import com.amazonaws.services.servicediscovery.model.OperationNotFoundException;
import com.amazonaws.services.servicediscovery.model.RegisterInstanceRequest;
import com.amazonaws.services.servicediscovery.model.RegisterInstanceResult;
import com.amazonaws.services.servicediscovery.model.ResourceInUseException;
import com.amazonaws.services.servicediscovery.model.ResourceLimitExceededException;
import com.amazonaws.services.servicediscovery.model.ServiceAlreadyExistsException;
import com.amazonaws.services.servicediscovery.model.ServiceNotFoundException;
import com.amazonaws.services.servicediscovery.model.UpdateInstanceCustomHealthStatusRequest;
import com.amazonaws.services.servicediscovery.model.UpdateInstanceCustomHealthStatusResult;
import com.amazonaws.services.servicediscovery.model.UpdateServiceRequest;
import com.amazonaws.services.servicediscovery.model.UpdateServiceResult;
import com.amazonaws.services.servicediscovery.model.transform.CreatePrivateDnsNamespaceRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.CreatePrivateDnsNamespaceResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.CreatePublicDnsNamespaceRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.CreatePublicDnsNamespaceResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.CreateServiceRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.CreateServiceResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.DeleteNamespaceRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.DeleteNamespaceResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.DeleteServiceRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.DeleteServiceResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.DeregisterInstanceRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.DeregisterInstanceResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.GetInstanceRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.GetInstanceResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.GetInstancesHealthStatusRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.GetInstancesHealthStatusResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.GetNamespaceRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.GetNamespaceResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.GetOperationRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.GetOperationResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.GetServiceRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.GetServiceResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.ListInstancesRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.ListInstancesResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.ListNamespacesRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.ListNamespacesResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.ListOperationsRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.ListOperationsResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.ListServicesRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.ListServicesResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.RegisterInstanceRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.RegisterInstanceResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.UpdateInstanceCustomHealthStatusRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.UpdateInstanceCustomHealthStatusResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.UpdateServiceRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.UpdateServiceResultJsonUnmarshaller;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;

@ThreadSafe
public class AWSServiceDiscoveryClient
extends AmazonWebServiceClient
implements AWSServiceDiscovery {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSServiceDiscovery.class);
    private static final String DEFAULT_SIGNING_NAME = "servicediscovery";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OperationNotFound").withModeledClass(OperationNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceInUse").withModeledClass(ResourceInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DuplicateRequest").withModeledClass(DuplicateRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidInput").withModeledClass(InvalidInputException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceAlreadyExists").withModeledClass(ServiceAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceNotFound").withModeledClass(ServiceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NamespaceAlreadyExists").withModeledClass(NamespaceAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InstanceNotFound").withModeledClass(InstanceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NamespaceNotFound").withModeledClass(NamespaceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CustomHealthNotFound").withModeledClass(CustomHealthNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceLimitExceeded").withModeledClass(ResourceLimitExceededException.class)).withBaseServiceExceptionClass(AWSServiceDiscoveryException.class));

    public static AWSServiceDiscoveryClientBuilder builder() {
        return AWSServiceDiscoveryClientBuilder.standard();
    }

    AWSServiceDiscoveryClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    AWSServiceDiscoveryClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("servicediscovery.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/servicediscovery/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/servicediscovery/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreatePrivateDnsNamespaceResult createPrivateDnsNamespace(CreatePrivateDnsNamespaceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreatePrivateDnsNamespace(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreatePrivateDnsNamespaceResult executeCreatePrivateDnsNamespace(CreatePrivateDnsNamespaceRequest createPrivateDnsNamespaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPrivateDnsNamespaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePrivateDnsNamespaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePrivateDnsNamespaceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createPrivateDnsNamespaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreatePrivateDnsNamespace");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreatePrivateDnsNamespaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreatePrivateDnsNamespaceResult createPrivateDnsNamespaceResult = (CreatePrivateDnsNamespaceResult)response.getAwsResponse();
            return createPrivateDnsNamespaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreatePublicDnsNamespaceResult createPublicDnsNamespace(CreatePublicDnsNamespaceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreatePublicDnsNamespace(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreatePublicDnsNamespaceResult executeCreatePublicDnsNamespace(CreatePublicDnsNamespaceRequest createPublicDnsNamespaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPublicDnsNamespaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePublicDnsNamespaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePublicDnsNamespaceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createPublicDnsNamespaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreatePublicDnsNamespace");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreatePublicDnsNamespaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreatePublicDnsNamespaceResult createPublicDnsNamespaceResult = (CreatePublicDnsNamespaceResult)response.getAwsResponse();
            return createPublicDnsNamespaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateServiceResult createService(CreateServiceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateService(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateServiceResult executeCreateService(CreateServiceRequest createServiceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createServiceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateServiceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateServiceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createServiceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateService");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateServiceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateServiceResult createServiceResult = (CreateServiceResult)response.getAwsResponse();
            return createServiceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteNamespace(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteNamespaceResult executeDeleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteNamespaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteNamespaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteNamespaceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteNamespaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteNamespace");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteNamespaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteNamespaceResult deleteNamespaceResult = (DeleteNamespaceResult)response.getAwsResponse();
            return deleteNamespaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteServiceResult deleteService(DeleteServiceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteService(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteServiceResult executeDeleteService(DeleteServiceRequest deleteServiceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteServiceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteServiceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteServiceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteServiceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteService");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteServiceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteServiceResult deleteServiceResult = (DeleteServiceResult)response.getAwsResponse();
            return deleteServiceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeregisterInstanceResult deregisterInstance(DeregisterInstanceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeregisterInstance(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeregisterInstanceResult executeDeregisterInstance(DeregisterInstanceRequest deregisterInstanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deregisterInstanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeregisterInstanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeregisterInstanceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deregisterInstanceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeregisterInstance");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeregisterInstanceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeregisterInstanceResult deregisterInstanceResult = (DeregisterInstanceResult)response.getAwsResponse();
            return deregisterInstanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetInstanceResult getInstance(GetInstanceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetInstance(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetInstanceResult executeGetInstance(GetInstanceRequest getInstanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getInstanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetInstanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetInstanceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getInstanceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetInstance");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetInstanceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetInstanceResult getInstanceResult = (GetInstanceResult)response.getAwsResponse();
            return getInstanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetInstancesHealthStatusResult getInstancesHealthStatus(GetInstancesHealthStatusRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetInstancesHealthStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetInstancesHealthStatusResult executeGetInstancesHealthStatus(GetInstancesHealthStatusRequest getInstancesHealthStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getInstancesHealthStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetInstancesHealthStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetInstancesHealthStatusRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getInstancesHealthStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetInstancesHealthStatus");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetInstancesHealthStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetInstancesHealthStatusResult getInstancesHealthStatusResult = (GetInstancesHealthStatusResult)response.getAwsResponse();
            return getInstancesHealthStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetNamespace(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetNamespaceResult executeGetNamespace(GetNamespaceRequest getNamespaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getNamespaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetNamespaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetNamespaceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getNamespaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetNamespace");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetNamespaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetNamespaceResult getNamespaceResult = (GetNamespaceResult)response.getAwsResponse();
            return getNamespaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetOperationResult getOperation(GetOperationRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetOperation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetOperationResult executeGetOperation(GetOperationRequest getOperationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getOperationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetOperationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetOperationRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getOperationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetOperation");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetOperationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetOperationResult getOperationResult = (GetOperationResult)response.getAwsResponse();
            return getOperationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetServiceResult getService(GetServiceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetService(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetServiceResult executeGetService(GetServiceRequest getServiceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getServiceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetServiceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetServiceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getServiceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetService");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetServiceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetServiceResult getServiceResult = (GetServiceResult)response.getAwsResponse();
            return getServiceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListInstancesResult listInstances(ListInstancesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListInstances(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListInstancesResult executeListInstances(ListInstancesRequest listInstancesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listInstancesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListInstancesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListInstancesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listInstancesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListInstances");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListInstancesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListInstancesResult listInstancesResult = (ListInstancesResult)response.getAwsResponse();
            return listInstancesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListNamespacesResult listNamespaces(ListNamespacesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListNamespaces(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListNamespacesResult executeListNamespaces(ListNamespacesRequest listNamespacesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listNamespacesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListNamespacesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListNamespacesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listNamespacesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListNamespaces");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListNamespacesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListNamespacesResult listNamespacesResult = (ListNamespacesResult)response.getAwsResponse();
            return listNamespacesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListOperationsResult listOperations(ListOperationsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListOperations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListOperationsResult executeListOperations(ListOperationsRequest listOperationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listOperationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListOperationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListOperationsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listOperationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListOperations");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListOperationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListOperationsResult listOperationsResult = (ListOperationsResult)response.getAwsResponse();
            return listOperationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListServicesResult listServices(ListServicesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListServices(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListServicesResult executeListServices(ListServicesRequest listServicesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listServicesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListServicesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListServicesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listServicesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListServices");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListServicesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListServicesResult listServicesResult = (ListServicesResult)response.getAwsResponse();
            return listServicesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RegisterInstanceResult registerInstance(RegisterInstanceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeRegisterInstance(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RegisterInstanceResult executeRegisterInstance(RegisterInstanceRequest registerInstanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerInstanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterInstanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterInstanceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(registerInstanceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "RegisterInstance");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new RegisterInstanceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RegisterInstanceResult registerInstanceResult = (RegisterInstanceResult)response.getAwsResponse();
            return registerInstanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateInstanceCustomHealthStatusResult updateInstanceCustomHealthStatus(UpdateInstanceCustomHealthStatusRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateInstanceCustomHealthStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateInstanceCustomHealthStatusResult executeUpdateInstanceCustomHealthStatus(UpdateInstanceCustomHealthStatusRequest updateInstanceCustomHealthStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateInstanceCustomHealthStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateInstanceCustomHealthStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateInstanceCustomHealthStatusRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateInstanceCustomHealthStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateInstanceCustomHealthStatus");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateInstanceCustomHealthStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateInstanceCustomHealthStatusResult updateInstanceCustomHealthStatusResult = (UpdateInstanceCustomHealthStatusResult)response.getAwsResponse();
            return updateInstanceCustomHealthStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateServiceResult updateService(UpdateServiceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateService(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateServiceResult executeUpdateService(UpdateServiceRequest updateServiceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateServiceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateServiceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateServiceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateServiceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateService");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateServiceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateServiceResult updateServiceResult = (UpdateServiceResult)response.getAwsResponse();
            return updateServiceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

