/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.secretsmanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.secretsmanager.model.transform.SecretVersionsListEntryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class SecretVersionsListEntry
implements Serializable,
Cloneable,
StructuredPojo {
    private String versionId;
    private List<String> versionStages;
    private Date lastAccessedDate;
    private Date createdDate;

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public SecretVersionsListEntry withVersionId(String versionId) {
        this.setVersionId(versionId);
        return this;
    }

    public List<String> getVersionStages() {
        return this.versionStages;
    }

    public void setVersionStages(Collection<String> versionStages) {
        if (versionStages == null) {
            this.versionStages = null;
            return;
        }
        this.versionStages = new ArrayList<String>(versionStages);
    }

    public SecretVersionsListEntry withVersionStages(String ... versionStages) {
        if (this.versionStages == null) {
            this.setVersionStages(new ArrayList<String>(versionStages.length));
        }
        for (String ele : versionStages) {
            this.versionStages.add(ele);
        }
        return this;
    }

    public SecretVersionsListEntry withVersionStages(Collection<String> versionStages) {
        this.setVersionStages(versionStages);
        return this;
    }

    public void setLastAccessedDate(Date lastAccessedDate) {
        this.lastAccessedDate = lastAccessedDate;
    }

    public Date getLastAccessedDate() {
        return this.lastAccessedDate;
    }

    public SecretVersionsListEntry withLastAccessedDate(Date lastAccessedDate) {
        this.setLastAccessedDate(lastAccessedDate);
        return this;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public SecretVersionsListEntry withCreatedDate(Date createdDate) {
        this.setCreatedDate(createdDate);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVersionId() != null) {
            sb.append("VersionId: ").append(this.getVersionId()).append(",");
        }
        if (this.getVersionStages() != null) {
            sb.append("VersionStages: ").append(this.getVersionStages()).append(",");
        }
        if (this.getLastAccessedDate() != null) {
            sb.append("LastAccessedDate: ").append(this.getLastAccessedDate()).append(",");
        }
        if (this.getCreatedDate() != null) {
            sb.append("CreatedDate: ").append(this.getCreatedDate());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecretVersionsListEntry)) {
            return false;
        }
        SecretVersionsListEntry other = (SecretVersionsListEntry)obj;
        if (other.getVersionId() == null ^ this.getVersionId() == null) {
            return false;
        }
        if (other.getVersionId() != null && !other.getVersionId().equals(this.getVersionId())) {
            return false;
        }
        if (other.getVersionStages() == null ^ this.getVersionStages() == null) {
            return false;
        }
        if (other.getVersionStages() != null && !other.getVersionStages().equals(this.getVersionStages())) {
            return false;
        }
        if (other.getLastAccessedDate() == null ^ this.getLastAccessedDate() == null) {
            return false;
        }
        if (other.getLastAccessedDate() != null && !other.getLastAccessedDate().equals(this.getLastAccessedDate())) {
            return false;
        }
        if (other.getCreatedDate() == null ^ this.getCreatedDate() == null) {
            return false;
        }
        return other.getCreatedDate() == null || other.getCreatedDate().equals(this.getCreatedDate());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVersionId() == null ? 0 : this.getVersionId().hashCode());
        hashCode = 31 * hashCode + (this.getVersionStages() == null ? 0 : this.getVersionStages().hashCode());
        hashCode = 31 * hashCode + (this.getLastAccessedDate() == null ? 0 : this.getLastAccessedDate().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedDate() == null ? 0 : this.getCreatedDate().hashCode());
        return hashCode;
    }

    public SecretVersionsListEntry clone() {
        try {
            return (SecretVersionsListEntry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SecretVersionsListEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

