/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.Channel;
import com.amazonaws.services.sagemaker.model.HyperParameterAlgorithmSpecification;
import com.amazonaws.services.sagemaker.model.OutputDataConfig;
import com.amazonaws.services.sagemaker.model.ResourceConfig;
import com.amazonaws.services.sagemaker.model.StoppingCondition;
import com.amazonaws.services.sagemaker.model.VpcConfig;
import com.amazonaws.services.sagemaker.model.transform.HyperParameterTrainingJobDefinitionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HyperParameterTrainingJobDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, String> staticHyperParameters;
    private HyperParameterAlgorithmSpecification algorithmSpecification;
    private String roleArn;
    private List<Channel> inputDataConfig;
    private VpcConfig vpcConfig;
    private OutputDataConfig outputDataConfig;
    private ResourceConfig resourceConfig;
    private StoppingCondition stoppingCondition;

    public Map<String, String> getStaticHyperParameters() {
        return this.staticHyperParameters;
    }

    public void setStaticHyperParameters(Map<String, String> staticHyperParameters) {
        this.staticHyperParameters = staticHyperParameters;
    }

    public HyperParameterTrainingJobDefinition withStaticHyperParameters(Map<String, String> staticHyperParameters) {
        this.setStaticHyperParameters(staticHyperParameters);
        return this;
    }

    public HyperParameterTrainingJobDefinition addStaticHyperParametersEntry(String key, String value) {
        if (null == this.staticHyperParameters) {
            this.staticHyperParameters = new HashMap<String, String>();
        }
        if (this.staticHyperParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.staticHyperParameters.put(key, value);
        return this;
    }

    public HyperParameterTrainingJobDefinition clearStaticHyperParametersEntries() {
        this.staticHyperParameters = null;
        return this;
    }

    public void setAlgorithmSpecification(HyperParameterAlgorithmSpecification algorithmSpecification) {
        this.algorithmSpecification = algorithmSpecification;
    }

    public HyperParameterAlgorithmSpecification getAlgorithmSpecification() {
        return this.algorithmSpecification;
    }

    public HyperParameterTrainingJobDefinition withAlgorithmSpecification(HyperParameterAlgorithmSpecification algorithmSpecification) {
        this.setAlgorithmSpecification(algorithmSpecification);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public HyperParameterTrainingJobDefinition withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public List<Channel> getInputDataConfig() {
        return this.inputDataConfig;
    }

    public void setInputDataConfig(Collection<Channel> inputDataConfig) {
        if (inputDataConfig == null) {
            this.inputDataConfig = null;
            return;
        }
        this.inputDataConfig = new ArrayList<Channel>(inputDataConfig);
    }

    public HyperParameterTrainingJobDefinition withInputDataConfig(Channel ... inputDataConfig) {
        if (this.inputDataConfig == null) {
            this.setInputDataConfig(new ArrayList<Channel>(inputDataConfig.length));
        }
        for (Channel ele : inputDataConfig) {
            this.inputDataConfig.add(ele);
        }
        return this;
    }

    public HyperParameterTrainingJobDefinition withInputDataConfig(Collection<Channel> inputDataConfig) {
        this.setInputDataConfig(inputDataConfig);
        return this;
    }

    public void setVpcConfig(VpcConfig vpcConfig) {
        this.vpcConfig = vpcConfig;
    }

    public VpcConfig getVpcConfig() {
        return this.vpcConfig;
    }

    public HyperParameterTrainingJobDefinition withVpcConfig(VpcConfig vpcConfig) {
        this.setVpcConfig(vpcConfig);
        return this;
    }

    public void setOutputDataConfig(OutputDataConfig outputDataConfig) {
        this.outputDataConfig = outputDataConfig;
    }

    public OutputDataConfig getOutputDataConfig() {
        return this.outputDataConfig;
    }

    public HyperParameterTrainingJobDefinition withOutputDataConfig(OutputDataConfig outputDataConfig) {
        this.setOutputDataConfig(outputDataConfig);
        return this;
    }

    public void setResourceConfig(ResourceConfig resourceConfig) {
        this.resourceConfig = resourceConfig;
    }

    public ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public HyperParameterTrainingJobDefinition withResourceConfig(ResourceConfig resourceConfig) {
        this.setResourceConfig(resourceConfig);
        return this;
    }

    public void setStoppingCondition(StoppingCondition stoppingCondition) {
        this.stoppingCondition = stoppingCondition;
    }

    public StoppingCondition getStoppingCondition() {
        return this.stoppingCondition;
    }

    public HyperParameterTrainingJobDefinition withStoppingCondition(StoppingCondition stoppingCondition) {
        this.setStoppingCondition(stoppingCondition);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStaticHyperParameters() != null) {
            sb.append("StaticHyperParameters: ").append(this.getStaticHyperParameters()).append(",");
        }
        if (this.getAlgorithmSpecification() != null) {
            sb.append("AlgorithmSpecification: ").append(this.getAlgorithmSpecification()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getInputDataConfig() != null) {
            sb.append("InputDataConfig: ").append(this.getInputDataConfig()).append(",");
        }
        if (this.getVpcConfig() != null) {
            sb.append("VpcConfig: ").append(this.getVpcConfig()).append(",");
        }
        if (this.getOutputDataConfig() != null) {
            sb.append("OutputDataConfig: ").append(this.getOutputDataConfig()).append(",");
        }
        if (this.getResourceConfig() != null) {
            sb.append("ResourceConfig: ").append(this.getResourceConfig()).append(",");
        }
        if (this.getStoppingCondition() != null) {
            sb.append("StoppingCondition: ").append(this.getStoppingCondition());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterTrainingJobDefinition)) {
            return false;
        }
        HyperParameterTrainingJobDefinition other = (HyperParameterTrainingJobDefinition)obj;
        if (other.getStaticHyperParameters() == null ^ this.getStaticHyperParameters() == null) {
            return false;
        }
        if (other.getStaticHyperParameters() != null && !other.getStaticHyperParameters().equals(this.getStaticHyperParameters())) {
            return false;
        }
        if (other.getAlgorithmSpecification() == null ^ this.getAlgorithmSpecification() == null) {
            return false;
        }
        if (other.getAlgorithmSpecification() != null && !other.getAlgorithmSpecification().equals(this.getAlgorithmSpecification())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getInputDataConfig() == null ^ this.getInputDataConfig() == null) {
            return false;
        }
        if (other.getInputDataConfig() != null && !other.getInputDataConfig().equals(this.getInputDataConfig())) {
            return false;
        }
        if (other.getVpcConfig() == null ^ this.getVpcConfig() == null) {
            return false;
        }
        if (other.getVpcConfig() != null && !other.getVpcConfig().equals(this.getVpcConfig())) {
            return false;
        }
        if (other.getOutputDataConfig() == null ^ this.getOutputDataConfig() == null) {
            return false;
        }
        if (other.getOutputDataConfig() != null && !other.getOutputDataConfig().equals(this.getOutputDataConfig())) {
            return false;
        }
        if (other.getResourceConfig() == null ^ this.getResourceConfig() == null) {
            return false;
        }
        if (other.getResourceConfig() != null && !other.getResourceConfig().equals(this.getResourceConfig())) {
            return false;
        }
        if (other.getStoppingCondition() == null ^ this.getStoppingCondition() == null) {
            return false;
        }
        return other.getStoppingCondition() == null || other.getStoppingCondition().equals(this.getStoppingCondition());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStaticHyperParameters() == null ? 0 : this.getStaticHyperParameters().hashCode());
        hashCode = 31 * hashCode + (this.getAlgorithmSpecification() == null ? 0 : this.getAlgorithmSpecification().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getInputDataConfig() == null ? 0 : this.getInputDataConfig().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfig() == null ? 0 : this.getVpcConfig().hashCode());
        hashCode = 31 * hashCode + (this.getOutputDataConfig() == null ? 0 : this.getOutputDataConfig().hashCode());
        hashCode = 31 * hashCode + (this.getResourceConfig() == null ? 0 : this.getResourceConfig().hashCode());
        hashCode = 31 * hashCode + (this.getStoppingCondition() == null ? 0 : this.getStoppingCondition().hashCode());
        return hashCode;
    }

    public HyperParameterTrainingJobDefinition clone() {
        try {
            return (HyperParameterTrainingJobDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HyperParameterTrainingJobDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

