/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.GPSPointDimension;

@SdkInternalApi
public class GPSPointDimensionMarshaller {
    private static final MarshallingInfo<StructuredPojo> COORDINATES_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Coordinates").build();
    private static final MarshallingInfo<Double> RANGEINKILOMETERS_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RangeInKilometers").build();
    private static final GPSPointDimensionMarshaller instance = new GPSPointDimensionMarshaller();

    public static GPSPointDimensionMarshaller getInstance() {
        return instance;
    }

    public void marshall(GPSPointDimension gPSPointDimension, ProtocolMarshaller protocolMarshaller) {
        if (gPSPointDimension == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(gPSPointDimension.getCoordinates(), COORDINATES_BINDING);
            protocolMarshaller.marshall(gPSPointDimension.getRangeInKilometers(), RANGEINKILOMETERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

