/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.Include;
import com.amazonaws.services.pinpoint.model.SegmentGroup;
import com.amazonaws.services.pinpoint.model.transform.SegmentGroupListMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SegmentGroupList
implements Serializable,
Cloneable,
StructuredPojo {
    private List<SegmentGroup> groups;
    private String include;

    public List<SegmentGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(Collection<SegmentGroup> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        this.groups = new ArrayList<SegmentGroup>(groups);
    }

    public SegmentGroupList withGroups(SegmentGroup ... groups) {
        if (this.groups == null) {
            this.setGroups(new ArrayList<SegmentGroup>(groups.length));
        }
        for (SegmentGroup ele : groups) {
            this.groups.add(ele);
        }
        return this;
    }

    public SegmentGroupList withGroups(Collection<SegmentGroup> groups) {
        this.setGroups(groups);
        return this;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public String getInclude() {
        return this.include;
    }

    public SegmentGroupList withInclude(String include) {
        this.setInclude(include);
        return this;
    }

    public SegmentGroupList withInclude(Include include) {
        this.include = include.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGroups() != null) {
            sb.append("Groups: ").append(this.getGroups()).append(",");
        }
        if (this.getInclude() != null) {
            sb.append("Include: ").append(this.getInclude());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentGroupList)) {
            return false;
        }
        SegmentGroupList other = (SegmentGroupList)obj;
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        if (other.getGroups() != null && !other.getGroups().equals(this.getGroups())) {
            return false;
        }
        if (other.getInclude() == null ^ this.getInclude() == null) {
            return false;
        }
        return other.getInclude() == null || other.getInclude().equals(this.getInclude());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : this.getGroups().hashCode());
        hashCode = 31 * hashCode + (this.getInclude() == null ? 0 : this.getInclude().hashCode());
        return hashCode;
    }

    public SegmentGroupList clone() {
        try {
            return (SegmentGroupList)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SegmentGroupListMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

