/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.Session;
import com.amazonaws.services.pinpoint.model.transform.EventMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Event
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, String> attributes;
    private String clientSdkVersion;
    private String eventType;
    private Map<String, Double> metrics;
    private Session session;
    private String timestamp;

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public Event withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public Event addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, String>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public Event clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public void setClientSdkVersion(String clientSdkVersion) {
        this.clientSdkVersion = clientSdkVersion;
    }

    public String getClientSdkVersion() {
        return this.clientSdkVersion;
    }

    public Event withClientSdkVersion(String clientSdkVersion) {
        this.setClientSdkVersion(clientSdkVersion);
        return this;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getEventType() {
        return this.eventType;
    }

    public Event withEventType(String eventType) {
        this.setEventType(eventType);
        return this;
    }

    public Map<String, Double> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Map<String, Double> metrics) {
        this.metrics = metrics;
    }

    public Event withMetrics(Map<String, Double> metrics) {
        this.setMetrics(metrics);
        return this;
    }

    public Event addMetricsEntry(String key, Double value) {
        if (null == this.metrics) {
            this.metrics = new HashMap<String, Double>();
        }
        if (this.metrics.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.metrics.put(key, value);
        return this;
    }

    public Event clearMetricsEntries() {
        this.metrics = null;
        return this;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public Event withSession(Session session) {
        this.setSession(session);
        return this;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public Event withTimestamp(String timestamp) {
        this.setTimestamp(timestamp);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getClientSdkVersion() != null) {
            sb.append("ClientSdkVersion: ").append(this.getClientSdkVersion()).append(",");
        }
        if (this.getEventType() != null) {
            sb.append("EventType: ").append(this.getEventType()).append(",");
        }
        if (this.getMetrics() != null) {
            sb.append("Metrics: ").append(this.getMetrics()).append(",");
        }
        if (this.getSession() != null) {
            sb.append("Session: ").append(this.getSession()).append(",");
        }
        if (this.getTimestamp() != null) {
            sb.append("Timestamp: ").append(this.getTimestamp());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getClientSdkVersion() == null ^ this.getClientSdkVersion() == null) {
            return false;
        }
        if (other.getClientSdkVersion() != null && !other.getClientSdkVersion().equals(this.getClientSdkVersion())) {
            return false;
        }
        if (other.getEventType() == null ^ this.getEventType() == null) {
            return false;
        }
        if (other.getEventType() != null && !other.getEventType().equals(this.getEventType())) {
            return false;
        }
        if (other.getMetrics() == null ^ this.getMetrics() == null) {
            return false;
        }
        if (other.getMetrics() != null && !other.getMetrics().equals(this.getMetrics())) {
            return false;
        }
        if (other.getSession() == null ^ this.getSession() == null) {
            return false;
        }
        if (other.getSession() != null && !other.getSession().equals(this.getSession())) {
            return false;
        }
        if (other.getTimestamp() == null ^ this.getTimestamp() == null) {
            return false;
        }
        return other.getTimestamp() == null || other.getTimestamp().equals(this.getTimestamp());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getClientSdkVersion() == null ? 0 : this.getClientSdkVersion().hashCode());
        hashCode = 31 * hashCode + (this.getEventType() == null ? 0 : this.getEventType().hashCode());
        hashCode = 31 * hashCode + (this.getMetrics() == null ? 0 : this.getMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getSession() == null ? 0 : this.getSession().hashCode());
        hashCode = 31 * hashCode + (this.getTimestamp() == null ? 0 : this.getTimestamp().hashCode());
        return hashCode;
    }

    public Event clone() {
        try {
            return (Event)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

