/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pi.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pi.model.transform.ResponsePartitionKeyMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ResponsePartitionKey
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, String> dimensions;

    public Map<String, String> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Map<String, String> dimensions) {
        this.dimensions = dimensions;
    }

    public ResponsePartitionKey withDimensions(Map<String, String> dimensions) {
        this.setDimensions(dimensions);
        return this;
    }

    public ResponsePartitionKey addDimensionsEntry(String key, String value) {
        if (null == this.dimensions) {
            this.dimensions = new HashMap<String, String>();
        }
        if (this.dimensions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.dimensions.put(key, value);
        return this;
    }

    public ResponsePartitionKey clearDimensionsEntries() {
        this.dimensions = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDimensions() != null) {
            sb.append("Dimensions: ").append(this.getDimensions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponsePartitionKey)) {
            return false;
        }
        ResponsePartitionKey other = (ResponsePartitionKey)obj;
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        return other.getDimensions() == null || other.getDimensions().equals(this.getDimensions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        return hashCode;
    }

    public ResponsePartitionKey clone() {
        try {
            return (ResponsePartitionKey)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResponsePartitionKeyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

