/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pi;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.pi.AWSPIAsync;
import com.amazonaws.services.pi.AWSPIAsyncClientBuilder;
import com.amazonaws.services.pi.AWSPIClient;
import com.amazonaws.services.pi.model.DescribeDimensionKeysRequest;
import com.amazonaws.services.pi.model.DescribeDimensionKeysResult;
import com.amazonaws.services.pi.model.GetResourceMetricsRequest;
import com.amazonaws.services.pi.model.GetResourceMetricsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSPIAsyncClient
extends AWSPIClient
implements AWSPIAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSPIAsyncClientBuilder asyncBuilder() {
        return AWSPIAsyncClientBuilder.standard();
    }

    AWSPIAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DescribeDimensionKeysResult> describeDimensionKeysAsync(DescribeDimensionKeysRequest request) {
        return this.describeDimensionKeysAsync(request, null);
    }

    @Override
    public Future<DescribeDimensionKeysResult> describeDimensionKeysAsync(DescribeDimensionKeysRequest request, final AsyncHandler<DescribeDimensionKeysRequest, DescribeDimensionKeysResult> asyncHandler) {
        final DescribeDimensionKeysRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDimensionKeysResult>(){

            @Override
            public DescribeDimensionKeysResult call() throws Exception {
                DescribeDimensionKeysResult result = null;
                try {
                    result = AWSPIAsyncClient.this.executeDescribeDimensionKeys(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetResourceMetricsResult> getResourceMetricsAsync(GetResourceMetricsRequest request) {
        return this.getResourceMetricsAsync(request, null);
    }

    @Override
    public Future<GetResourceMetricsResult> getResourceMetricsAsync(GetResourceMetricsRequest request, final AsyncHandler<GetResourceMetricsRequest, GetResourceMetricsResult> asyncHandler) {
        final GetResourceMetricsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetResourceMetricsResult>(){

            @Override
            public GetResourceMetricsResult call() throws Exception {
                GetResourceMetricsResult result = null;
                try {
                    result = AWSPIAsyncClient.this.executeGetResourceMetrics(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

