/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.neptune.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.neptune.model.CopyDBParameterGroupRequest;
import com.amazonaws.services.neptune.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CopyDBParameterGroupRequestMarshaller
implements Marshaller<Request<CopyDBParameterGroupRequest>, CopyDBParameterGroupRequest> {
    @Override
    public Request<CopyDBParameterGroupRequest> marshall(CopyDBParameterGroupRequest copyDBParameterGroupRequest) {
        if (copyDBParameterGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CopyDBParameterGroupRequest> request = new DefaultRequest<CopyDBParameterGroupRequest>(copyDBParameterGroupRequest, "AmazonNeptune");
        request.addParameter("Action", "CopyDBParameterGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (copyDBParameterGroupRequest.getSourceDBParameterGroupIdentifier() != null) {
            request.addParameter("SourceDBParameterGroupIdentifier", StringUtils.fromString(copyDBParameterGroupRequest.getSourceDBParameterGroupIdentifier()));
        }
        if (copyDBParameterGroupRequest.getTargetDBParameterGroupIdentifier() != null) {
            request.addParameter("TargetDBParameterGroupIdentifier", StringUtils.fromString(copyDBParameterGroupRequest.getTargetDBParameterGroupIdentifier()));
        }
        if (copyDBParameterGroupRequest.getTargetDBParameterGroupDescription() != null) {
            request.addParameter("TargetDBParameterGroupDescription", StringUtils.fromString(copyDBParameterGroupRequest.getTargetDBParameterGroupDescription()));
        }
        if (copyDBParameterGroupRequest.getTags() != null) {
            List<Tag> tagsList = copyDBParameterGroupRequest.getTags();
            if (tagsList.isEmpty()) {
                request.addParameter("Tags", "");
            } else {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                    }
                    ++tagsListIndex;
                }
            }
        }
        return request;
    }
}

