/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mq.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mq.model.Logs;

@SdkInternalApi
public class LogsMarshaller {
    private static final MarshallingInfo<Boolean> AUDIT_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audit").build();
    private static final MarshallingInfo<Boolean> GENERAL_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("general").build();
    private static final LogsMarshaller instance = new LogsMarshaller();

    public static LogsMarshaller getInstance() {
        return instance;
    }

    public void marshall(Logs logs, ProtocolMarshaller protocolMarshaller) {
        if (logs == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(logs.getAudit(), AUDIT_BINDING);
            protocolMarshaller.marshall(logs.getGeneral(), GENERAL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

