/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediastore.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediastore.model.MethodName;
import com.amazonaws.services.mediastore.model.transform.CorsRuleMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CorsRule
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> allowedOrigins;
    private List<String> allowedMethods;
    private List<String> allowedHeaders;
    private Integer maxAgeSeconds;
    private List<String> exposeHeaders;

    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void setAllowedOrigins(Collection<String> allowedOrigins) {
        if (allowedOrigins == null) {
            this.allowedOrigins = null;
            return;
        }
        this.allowedOrigins = new ArrayList<String>(allowedOrigins);
    }

    public CorsRule withAllowedOrigins(String ... allowedOrigins) {
        if (this.allowedOrigins == null) {
            this.setAllowedOrigins(new ArrayList<String>(allowedOrigins.length));
        }
        for (String ele : allowedOrigins) {
            this.allowedOrigins.add(ele);
        }
        return this;
    }

    public CorsRule withAllowedOrigins(Collection<String> allowedOrigins) {
        this.setAllowedOrigins(allowedOrigins);
        return this;
    }

    public List<String> getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(Collection<String> allowedMethods) {
        if (allowedMethods == null) {
            this.allowedMethods = null;
            return;
        }
        this.allowedMethods = new ArrayList<String>(allowedMethods);
    }

    public CorsRule withAllowedMethods(String ... allowedMethods) {
        if (this.allowedMethods == null) {
            this.setAllowedMethods(new ArrayList<String>(allowedMethods.length));
        }
        for (String ele : allowedMethods) {
            this.allowedMethods.add(ele);
        }
        return this;
    }

    public CorsRule withAllowedMethods(Collection<String> allowedMethods) {
        this.setAllowedMethods(allowedMethods);
        return this;
    }

    public CorsRule withAllowedMethods(MethodName ... allowedMethods) {
        ArrayList<String> allowedMethodsCopy = new ArrayList<String>(allowedMethods.length);
        for (MethodName value : allowedMethods) {
            allowedMethodsCopy.add(value.toString());
        }
        if (this.getAllowedMethods() == null) {
            this.setAllowedMethods(allowedMethodsCopy);
        } else {
            this.getAllowedMethods().addAll(allowedMethodsCopy);
        }
        return this;
    }

    public List<String> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public void setAllowedHeaders(Collection<String> allowedHeaders) {
        if (allowedHeaders == null) {
            this.allowedHeaders = null;
            return;
        }
        this.allowedHeaders = new ArrayList<String>(allowedHeaders);
    }

    public CorsRule withAllowedHeaders(String ... allowedHeaders) {
        if (this.allowedHeaders == null) {
            this.setAllowedHeaders(new ArrayList<String>(allowedHeaders.length));
        }
        for (String ele : allowedHeaders) {
            this.allowedHeaders.add(ele);
        }
        return this;
    }

    public CorsRule withAllowedHeaders(Collection<String> allowedHeaders) {
        this.setAllowedHeaders(allowedHeaders);
        return this;
    }

    public void setMaxAgeSeconds(Integer maxAgeSeconds) {
        this.maxAgeSeconds = maxAgeSeconds;
    }

    public Integer getMaxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public CorsRule withMaxAgeSeconds(Integer maxAgeSeconds) {
        this.setMaxAgeSeconds(maxAgeSeconds);
        return this;
    }

    public List<String> getExposeHeaders() {
        return this.exposeHeaders;
    }

    public void setExposeHeaders(Collection<String> exposeHeaders) {
        if (exposeHeaders == null) {
            this.exposeHeaders = null;
            return;
        }
        this.exposeHeaders = new ArrayList<String>(exposeHeaders);
    }

    public CorsRule withExposeHeaders(String ... exposeHeaders) {
        if (this.exposeHeaders == null) {
            this.setExposeHeaders(new ArrayList<String>(exposeHeaders.length));
        }
        for (String ele : exposeHeaders) {
            this.exposeHeaders.add(ele);
        }
        return this;
    }

    public CorsRule withExposeHeaders(Collection<String> exposeHeaders) {
        this.setExposeHeaders(exposeHeaders);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAllowedOrigins() != null) {
            sb.append("AllowedOrigins: ").append(this.getAllowedOrigins()).append(",");
        }
        if (this.getAllowedMethods() != null) {
            sb.append("AllowedMethods: ").append(this.getAllowedMethods()).append(",");
        }
        if (this.getAllowedHeaders() != null) {
            sb.append("AllowedHeaders: ").append(this.getAllowedHeaders()).append(",");
        }
        if (this.getMaxAgeSeconds() != null) {
            sb.append("MaxAgeSeconds: ").append(this.getMaxAgeSeconds()).append(",");
        }
        if (this.getExposeHeaders() != null) {
            sb.append("ExposeHeaders: ").append(this.getExposeHeaders());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CorsRule)) {
            return false;
        }
        CorsRule other = (CorsRule)obj;
        if (other.getAllowedOrigins() == null ^ this.getAllowedOrigins() == null) {
            return false;
        }
        if (other.getAllowedOrigins() != null && !other.getAllowedOrigins().equals(this.getAllowedOrigins())) {
            return false;
        }
        if (other.getAllowedMethods() == null ^ this.getAllowedMethods() == null) {
            return false;
        }
        if (other.getAllowedMethods() != null && !other.getAllowedMethods().equals(this.getAllowedMethods())) {
            return false;
        }
        if (other.getAllowedHeaders() == null ^ this.getAllowedHeaders() == null) {
            return false;
        }
        if (other.getAllowedHeaders() != null && !other.getAllowedHeaders().equals(this.getAllowedHeaders())) {
            return false;
        }
        if (other.getMaxAgeSeconds() == null ^ this.getMaxAgeSeconds() == null) {
            return false;
        }
        if (other.getMaxAgeSeconds() != null && !other.getMaxAgeSeconds().equals(this.getMaxAgeSeconds())) {
            return false;
        }
        if (other.getExposeHeaders() == null ^ this.getExposeHeaders() == null) {
            return false;
        }
        return other.getExposeHeaders() == null || other.getExposeHeaders().equals(this.getExposeHeaders());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAllowedOrigins() == null ? 0 : this.getAllowedOrigins().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedMethods() == null ? 0 : this.getAllowedMethods().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedHeaders() == null ? 0 : this.getAllowedHeaders().hashCode());
        hashCode = 31 * hashCode + (this.getMaxAgeSeconds() == null ? 0 : this.getMaxAgeSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getExposeHeaders() == null ? 0 : this.getExposeHeaders().hashCode());
        return hashCode;
    }

    public CorsRule clone() {
        try {
            return (CorsRule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CorsRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

