/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediapackage.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediapackage.model.DashEncryption;
import com.amazonaws.services.mediapackage.model.PeriodTriggersElement;
import com.amazonaws.services.mediapackage.model.Profile;
import com.amazonaws.services.mediapackage.model.StreamSelection;
import com.amazonaws.services.mediapackage.model.transform.DashPackageMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DashPackage
implements Serializable,
Cloneable,
StructuredPojo {
    private DashEncryption encryption;
    private Integer manifestWindowSeconds;
    private Integer minBufferTimeSeconds;
    private Integer minUpdatePeriodSeconds;
    private List<String> periodTriggers;
    private String profile;
    private Integer segmentDurationSeconds;
    private StreamSelection streamSelection;
    private Integer suggestedPresentationDelaySeconds;

    public void setEncryption(DashEncryption encryption) {
        this.encryption = encryption;
    }

    public DashEncryption getEncryption() {
        return this.encryption;
    }

    public DashPackage withEncryption(DashEncryption encryption) {
        this.setEncryption(encryption);
        return this;
    }

    public void setManifestWindowSeconds(Integer manifestWindowSeconds) {
        this.manifestWindowSeconds = manifestWindowSeconds;
    }

    public Integer getManifestWindowSeconds() {
        return this.manifestWindowSeconds;
    }

    public DashPackage withManifestWindowSeconds(Integer manifestWindowSeconds) {
        this.setManifestWindowSeconds(manifestWindowSeconds);
        return this;
    }

    public void setMinBufferTimeSeconds(Integer minBufferTimeSeconds) {
        this.minBufferTimeSeconds = minBufferTimeSeconds;
    }

    public Integer getMinBufferTimeSeconds() {
        return this.minBufferTimeSeconds;
    }

    public DashPackage withMinBufferTimeSeconds(Integer minBufferTimeSeconds) {
        this.setMinBufferTimeSeconds(minBufferTimeSeconds);
        return this;
    }

    public void setMinUpdatePeriodSeconds(Integer minUpdatePeriodSeconds) {
        this.minUpdatePeriodSeconds = minUpdatePeriodSeconds;
    }

    public Integer getMinUpdatePeriodSeconds() {
        return this.minUpdatePeriodSeconds;
    }

    public DashPackage withMinUpdatePeriodSeconds(Integer minUpdatePeriodSeconds) {
        this.setMinUpdatePeriodSeconds(minUpdatePeriodSeconds);
        return this;
    }

    public List<String> getPeriodTriggers() {
        return this.periodTriggers;
    }

    public void setPeriodTriggers(Collection<String> periodTriggers) {
        if (periodTriggers == null) {
            this.periodTriggers = null;
            return;
        }
        this.periodTriggers = new ArrayList<String>(periodTriggers);
    }

    public DashPackage withPeriodTriggers(String ... periodTriggers) {
        if (this.periodTriggers == null) {
            this.setPeriodTriggers(new ArrayList<String>(periodTriggers.length));
        }
        for (String ele : periodTriggers) {
            this.periodTriggers.add(ele);
        }
        return this;
    }

    public DashPackage withPeriodTriggers(Collection<String> periodTriggers) {
        this.setPeriodTriggers(periodTriggers);
        return this;
    }

    public DashPackage withPeriodTriggers(PeriodTriggersElement ... periodTriggers) {
        ArrayList<String> periodTriggersCopy = new ArrayList<String>(periodTriggers.length);
        for (PeriodTriggersElement value : periodTriggers) {
            periodTriggersCopy.add(value.toString());
        }
        if (this.getPeriodTriggers() == null) {
            this.setPeriodTriggers(periodTriggersCopy);
        } else {
            this.getPeriodTriggers().addAll(periodTriggersCopy);
        }
        return this;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getProfile() {
        return this.profile;
    }

    public DashPackage withProfile(String profile) {
        this.setProfile(profile);
        return this;
    }

    public DashPackage withProfile(Profile profile) {
        this.profile = profile.toString();
        return this;
    }

    public void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
        this.segmentDurationSeconds = segmentDurationSeconds;
    }

    public Integer getSegmentDurationSeconds() {
        return this.segmentDurationSeconds;
    }

    public DashPackage withSegmentDurationSeconds(Integer segmentDurationSeconds) {
        this.setSegmentDurationSeconds(segmentDurationSeconds);
        return this;
    }

    public void setStreamSelection(StreamSelection streamSelection) {
        this.streamSelection = streamSelection;
    }

    public StreamSelection getStreamSelection() {
        return this.streamSelection;
    }

    public DashPackage withStreamSelection(StreamSelection streamSelection) {
        this.setStreamSelection(streamSelection);
        return this;
    }

    public void setSuggestedPresentationDelaySeconds(Integer suggestedPresentationDelaySeconds) {
        this.suggestedPresentationDelaySeconds = suggestedPresentationDelaySeconds;
    }

    public Integer getSuggestedPresentationDelaySeconds() {
        return this.suggestedPresentationDelaySeconds;
    }

    public DashPackage withSuggestedPresentationDelaySeconds(Integer suggestedPresentationDelaySeconds) {
        this.setSuggestedPresentationDelaySeconds(suggestedPresentationDelaySeconds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEncryption() != null) {
            sb.append("Encryption: ").append(this.getEncryption()).append(",");
        }
        if (this.getManifestWindowSeconds() != null) {
            sb.append("ManifestWindowSeconds: ").append(this.getManifestWindowSeconds()).append(",");
        }
        if (this.getMinBufferTimeSeconds() != null) {
            sb.append("MinBufferTimeSeconds: ").append(this.getMinBufferTimeSeconds()).append(",");
        }
        if (this.getMinUpdatePeriodSeconds() != null) {
            sb.append("MinUpdatePeriodSeconds: ").append(this.getMinUpdatePeriodSeconds()).append(",");
        }
        if (this.getPeriodTriggers() != null) {
            sb.append("PeriodTriggers: ").append(this.getPeriodTriggers()).append(",");
        }
        if (this.getProfile() != null) {
            sb.append("Profile: ").append(this.getProfile()).append(",");
        }
        if (this.getSegmentDurationSeconds() != null) {
            sb.append("SegmentDurationSeconds: ").append(this.getSegmentDurationSeconds()).append(",");
        }
        if (this.getStreamSelection() != null) {
            sb.append("StreamSelection: ").append(this.getStreamSelection()).append(",");
        }
        if (this.getSuggestedPresentationDelaySeconds() != null) {
            sb.append("SuggestedPresentationDelaySeconds: ").append(this.getSuggestedPresentationDelaySeconds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashPackage)) {
            return false;
        }
        DashPackage other = (DashPackage)obj;
        if (other.getEncryption() == null ^ this.getEncryption() == null) {
            return false;
        }
        if (other.getEncryption() != null && !other.getEncryption().equals(this.getEncryption())) {
            return false;
        }
        if (other.getManifestWindowSeconds() == null ^ this.getManifestWindowSeconds() == null) {
            return false;
        }
        if (other.getManifestWindowSeconds() != null && !other.getManifestWindowSeconds().equals(this.getManifestWindowSeconds())) {
            return false;
        }
        if (other.getMinBufferTimeSeconds() == null ^ this.getMinBufferTimeSeconds() == null) {
            return false;
        }
        if (other.getMinBufferTimeSeconds() != null && !other.getMinBufferTimeSeconds().equals(this.getMinBufferTimeSeconds())) {
            return false;
        }
        if (other.getMinUpdatePeriodSeconds() == null ^ this.getMinUpdatePeriodSeconds() == null) {
            return false;
        }
        if (other.getMinUpdatePeriodSeconds() != null && !other.getMinUpdatePeriodSeconds().equals(this.getMinUpdatePeriodSeconds())) {
            return false;
        }
        if (other.getPeriodTriggers() == null ^ this.getPeriodTriggers() == null) {
            return false;
        }
        if (other.getPeriodTriggers() != null && !other.getPeriodTriggers().equals(this.getPeriodTriggers())) {
            return false;
        }
        if (other.getProfile() == null ^ this.getProfile() == null) {
            return false;
        }
        if (other.getProfile() != null && !other.getProfile().equals(this.getProfile())) {
            return false;
        }
        if (other.getSegmentDurationSeconds() == null ^ this.getSegmentDurationSeconds() == null) {
            return false;
        }
        if (other.getSegmentDurationSeconds() != null && !other.getSegmentDurationSeconds().equals(this.getSegmentDurationSeconds())) {
            return false;
        }
        if (other.getStreamSelection() == null ^ this.getStreamSelection() == null) {
            return false;
        }
        if (other.getStreamSelection() != null && !other.getStreamSelection().equals(this.getStreamSelection())) {
            return false;
        }
        if (other.getSuggestedPresentationDelaySeconds() == null ^ this.getSuggestedPresentationDelaySeconds() == null) {
            return false;
        }
        return other.getSuggestedPresentationDelaySeconds() == null || other.getSuggestedPresentationDelaySeconds().equals(this.getSuggestedPresentationDelaySeconds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEncryption() == null ? 0 : this.getEncryption().hashCode());
        hashCode = 31 * hashCode + (this.getManifestWindowSeconds() == null ? 0 : this.getManifestWindowSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getMinBufferTimeSeconds() == null ? 0 : this.getMinBufferTimeSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getMinUpdatePeriodSeconds() == null ? 0 : this.getMinUpdatePeriodSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getPeriodTriggers() == null ? 0 : this.getPeriodTriggers().hashCode());
        hashCode = 31 * hashCode + (this.getProfile() == null ? 0 : this.getProfile().hashCode());
        hashCode = 31 * hashCode + (this.getSegmentDurationSeconds() == null ? 0 : this.getSegmentDurationSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getStreamSelection() == null ? 0 : this.getStreamSelection().hashCode());
        hashCode = 31 * hashCode + (this.getSuggestedPresentationDelaySeconds() == null ? 0 : this.getSuggestedPresentationDelaySeconds().hashCode());
        return hashCode;
    }

    public DashPackage clone() {
        try {
            return (DashPackage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DashPackageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

