/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.medialive.AWSMediaLive;
import com.amazonaws.services.medialive.AWSMediaLiveClientBuilder;
import com.amazonaws.services.medialive.model.AWSMediaLiveException;
import com.amazonaws.services.medialive.model.BadGatewayException;
import com.amazonaws.services.medialive.model.BadRequestException;
import com.amazonaws.services.medialive.model.BatchUpdateScheduleRequest;
import com.amazonaws.services.medialive.model.BatchUpdateScheduleResult;
import com.amazonaws.services.medialive.model.ConflictException;
import com.amazonaws.services.medialive.model.CreateChannelRequest;
import com.amazonaws.services.medialive.model.CreateChannelResult;
import com.amazonaws.services.medialive.model.CreateInputRequest;
import com.amazonaws.services.medialive.model.CreateInputResult;
import com.amazonaws.services.medialive.model.CreateInputSecurityGroupRequest;
import com.amazonaws.services.medialive.model.CreateInputSecurityGroupResult;
import com.amazonaws.services.medialive.model.DeleteChannelRequest;
import com.amazonaws.services.medialive.model.DeleteChannelResult;
import com.amazonaws.services.medialive.model.DeleteInputRequest;
import com.amazonaws.services.medialive.model.DeleteInputResult;
import com.amazonaws.services.medialive.model.DeleteInputSecurityGroupRequest;
import com.amazonaws.services.medialive.model.DeleteInputSecurityGroupResult;
import com.amazonaws.services.medialive.model.DeleteReservationRequest;
import com.amazonaws.services.medialive.model.DeleteReservationResult;
import com.amazonaws.services.medialive.model.DescribeChannelRequest;
import com.amazonaws.services.medialive.model.DescribeChannelResult;
import com.amazonaws.services.medialive.model.DescribeInputRequest;
import com.amazonaws.services.medialive.model.DescribeInputResult;
import com.amazonaws.services.medialive.model.DescribeInputSecurityGroupRequest;
import com.amazonaws.services.medialive.model.DescribeInputSecurityGroupResult;
import com.amazonaws.services.medialive.model.DescribeOfferingRequest;
import com.amazonaws.services.medialive.model.DescribeOfferingResult;
import com.amazonaws.services.medialive.model.DescribeReservationRequest;
import com.amazonaws.services.medialive.model.DescribeReservationResult;
import com.amazonaws.services.medialive.model.DescribeScheduleRequest;
import com.amazonaws.services.medialive.model.DescribeScheduleResult;
import com.amazonaws.services.medialive.model.ForbiddenException;
import com.amazonaws.services.medialive.model.GatewayTimeoutException;
import com.amazonaws.services.medialive.model.InternalServerErrorException;
import com.amazonaws.services.medialive.model.ListChannelsRequest;
import com.amazonaws.services.medialive.model.ListChannelsResult;
import com.amazonaws.services.medialive.model.ListInputSecurityGroupsRequest;
import com.amazonaws.services.medialive.model.ListInputSecurityGroupsResult;
import com.amazonaws.services.medialive.model.ListInputsRequest;
import com.amazonaws.services.medialive.model.ListInputsResult;
import com.amazonaws.services.medialive.model.ListOfferingsRequest;
import com.amazonaws.services.medialive.model.ListOfferingsResult;
import com.amazonaws.services.medialive.model.ListReservationsRequest;
import com.amazonaws.services.medialive.model.ListReservationsResult;
import com.amazonaws.services.medialive.model.NotFoundException;
import com.amazonaws.services.medialive.model.PurchaseOfferingRequest;
import com.amazonaws.services.medialive.model.PurchaseOfferingResult;
import com.amazonaws.services.medialive.model.StartChannelRequest;
import com.amazonaws.services.medialive.model.StartChannelResult;
import com.amazonaws.services.medialive.model.StopChannelRequest;
import com.amazonaws.services.medialive.model.StopChannelResult;
import com.amazonaws.services.medialive.model.TooManyRequestsException;
import com.amazonaws.services.medialive.model.UnprocessableEntityException;
import com.amazonaws.services.medialive.model.UpdateChannelRequest;
import com.amazonaws.services.medialive.model.UpdateChannelResult;
import com.amazonaws.services.medialive.model.UpdateInputRequest;
import com.amazonaws.services.medialive.model.UpdateInputResult;
import com.amazonaws.services.medialive.model.UpdateInputSecurityGroupRequest;
import com.amazonaws.services.medialive.model.UpdateInputSecurityGroupResult;
import com.amazonaws.services.medialive.model.transform.BatchUpdateScheduleRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.BatchUpdateScheduleResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.CreateChannelRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.CreateChannelResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.CreateInputRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.CreateInputResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.CreateInputSecurityGroupRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.CreateInputSecurityGroupResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DeleteChannelRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DeleteChannelResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DeleteInputRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DeleteInputResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DeleteInputSecurityGroupRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DeleteInputSecurityGroupResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DeleteReservationRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DeleteReservationResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeChannelRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeChannelResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeInputRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeInputResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeInputSecurityGroupRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeInputSecurityGroupResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeOfferingRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeOfferingResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeReservationRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeReservationResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeScheduleRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.DescribeScheduleResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.ListChannelsRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.ListChannelsResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.ListInputSecurityGroupsRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.ListInputSecurityGroupsResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.ListInputsRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.ListInputsResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.ListOfferingsRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.ListOfferingsResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.ListReservationsRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.ListReservationsResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.PurchaseOfferingRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.PurchaseOfferingResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.StartChannelRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.StartChannelResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.StopChannelRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.StopChannelResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.UpdateChannelRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.UpdateChannelResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.UpdateInputRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.UpdateInputResultJsonUnmarshaller;
import com.amazonaws.services.medialive.model.transform.UpdateInputSecurityGroupRequestProtocolMarshaller;
import com.amazonaws.services.medialive.model.transform.UpdateInputSecurityGroupResultJsonUnmarshaller;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;

@ThreadSafe
public class AWSMediaLiveClient
extends AmazonWebServiceClient
implements AWSMediaLive {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSMediaLive.class);
    private static final String DEFAULT_SIGNING_NAME = "medialive";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadGatewayException").withModeledClass(BadGatewayException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ForbiddenException").withModeledClass(ForbiddenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(NotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withModeledClass(ConflictException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnprocessableEntityException").withModeledClass(UnprocessableEntityException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("GatewayTimeoutException").withModeledClass(GatewayTimeoutException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withModeledClass(TooManyRequestsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withModeledClass(BadRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerErrorException").withModeledClass(InternalServerErrorException.class)).withBaseServiceExceptionClass(AWSMediaLiveException.class));

    public static AWSMediaLiveClientBuilder builder() {
        return AWSMediaLiveClientBuilder.standard();
    }

    AWSMediaLiveClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    AWSMediaLiveClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("medialive.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/medialive/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/medialive/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchUpdateScheduleResult batchUpdateSchedule(BatchUpdateScheduleRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeBatchUpdateSchedule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchUpdateScheduleResult executeBatchUpdateSchedule(BatchUpdateScheduleRequest batchUpdateScheduleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchUpdateScheduleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchUpdateScheduleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchUpdateScheduleRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(batchUpdateScheduleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "BatchUpdateSchedule");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new BatchUpdateScheduleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchUpdateScheduleResult batchUpdateScheduleResult = (BatchUpdateScheduleResult)response.getAwsResponse();
            return batchUpdateScheduleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateChannelResult createChannel(CreateChannelRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateChannelResult executeCreateChannel(CreateChannelRequest createChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateChannelRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateChannel");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateChannelResult createChannelResult = (CreateChannelResult)response.getAwsResponse();
            return createChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateInputResult createInput(CreateInputRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateInput(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateInputResult executeCreateInput(CreateInputRequest createInputRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createInputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateInputRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateInputRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createInputRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateInput");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateInputResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateInputResult createInputResult = (CreateInputResult)response.getAwsResponse();
            return createInputResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateInputSecurityGroupResult createInputSecurityGroup(CreateInputSecurityGroupRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateInputSecurityGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateInputSecurityGroupResult executeCreateInputSecurityGroup(CreateInputSecurityGroupRequest createInputSecurityGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createInputSecurityGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateInputSecurityGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateInputSecurityGroupRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createInputSecurityGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateInputSecurityGroup");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateInputSecurityGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateInputSecurityGroupResult createInputSecurityGroupResult = (CreateInputSecurityGroupResult)response.getAwsResponse();
            return createInputSecurityGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteChannelResult deleteChannel(DeleteChannelRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteChannelResult executeDeleteChannel(DeleteChannelRequest deleteChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteChannelRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteChannel");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteChannelResult deleteChannelResult = (DeleteChannelResult)response.getAwsResponse();
            return deleteChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteInputResult deleteInput(DeleteInputRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteInput(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteInputResult executeDeleteInput(DeleteInputRequest deleteInputRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteInputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteInputRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteInputRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteInputRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteInput");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteInputResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteInputResult deleteInputResult = (DeleteInputResult)response.getAwsResponse();
            return deleteInputResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteInputSecurityGroupResult deleteInputSecurityGroup(DeleteInputSecurityGroupRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteInputSecurityGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteInputSecurityGroupResult executeDeleteInputSecurityGroup(DeleteInputSecurityGroupRequest deleteInputSecurityGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteInputSecurityGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteInputSecurityGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteInputSecurityGroupRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteInputSecurityGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteInputSecurityGroup");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteInputSecurityGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteInputSecurityGroupResult deleteInputSecurityGroupResult = (DeleteInputSecurityGroupResult)response.getAwsResponse();
            return deleteInputSecurityGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteReservationResult deleteReservation(DeleteReservationRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteReservation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteReservationResult executeDeleteReservation(DeleteReservationRequest deleteReservationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteReservationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteReservationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteReservationRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteReservationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteReservation");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteReservationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteReservationResult deleteReservationResult = (DeleteReservationResult)response.getAwsResponse();
            return deleteReservationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeChannelResult describeChannel(DescribeChannelRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeChannelResult executeDescribeChannel(DescribeChannelRequest describeChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeChannelRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeChannel");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeChannelResult describeChannelResult = (DescribeChannelResult)response.getAwsResponse();
            return describeChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeInputResult describeInput(DescribeInputRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeInput(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeInputResult executeDescribeInput(DescribeInputRequest describeInputRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeInputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeInputRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeInputRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeInputRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeInput");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeInputResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeInputResult describeInputResult = (DescribeInputResult)response.getAwsResponse();
            return describeInputResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeInputSecurityGroupResult describeInputSecurityGroup(DescribeInputSecurityGroupRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeInputSecurityGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeInputSecurityGroupResult executeDescribeInputSecurityGroup(DescribeInputSecurityGroupRequest describeInputSecurityGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeInputSecurityGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeInputSecurityGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeInputSecurityGroupRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeInputSecurityGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeInputSecurityGroup");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeInputSecurityGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeInputSecurityGroupResult describeInputSecurityGroupResult = (DescribeInputSecurityGroupResult)response.getAwsResponse();
            return describeInputSecurityGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeOfferingResult describeOffering(DescribeOfferingRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeOffering(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeOfferingResult executeDescribeOffering(DescribeOfferingRequest describeOfferingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeOfferingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeOfferingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeOfferingRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeOfferingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeOffering");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeOfferingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeOfferingResult describeOfferingResult = (DescribeOfferingResult)response.getAwsResponse();
            return describeOfferingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeReservationResult describeReservation(DescribeReservationRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeReservation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeReservationResult executeDescribeReservation(DescribeReservationRequest describeReservationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeReservationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeReservationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeReservationRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeReservationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeReservation");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeReservationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeReservationResult describeReservationResult = (DescribeReservationResult)response.getAwsResponse();
            return describeReservationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeScheduleResult describeSchedule(DescribeScheduleRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeSchedule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeScheduleResult executeDescribeSchedule(DescribeScheduleRequest describeScheduleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeScheduleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeScheduleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeScheduleRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeScheduleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeSchedule");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeScheduleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeScheduleResult describeScheduleResult = (DescribeScheduleResult)response.getAwsResponse();
            return describeScheduleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListChannelsResult listChannels(ListChannelsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListChannels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListChannelsResult executeListChannels(ListChannelsRequest listChannelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listChannelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListChannelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListChannelsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listChannelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListChannels");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListChannelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListChannelsResult listChannelsResult = (ListChannelsResult)response.getAwsResponse();
            return listChannelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListInputSecurityGroupsResult listInputSecurityGroups(ListInputSecurityGroupsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListInputSecurityGroups(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListInputSecurityGroupsResult executeListInputSecurityGroups(ListInputSecurityGroupsRequest listInputSecurityGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listInputSecurityGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListInputSecurityGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListInputSecurityGroupsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listInputSecurityGroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListInputSecurityGroups");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListInputSecurityGroupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListInputSecurityGroupsResult listInputSecurityGroupsResult = (ListInputSecurityGroupsResult)response.getAwsResponse();
            return listInputSecurityGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListInputsResult listInputs(ListInputsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListInputs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListInputsResult executeListInputs(ListInputsRequest listInputsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listInputsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListInputsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListInputsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listInputsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListInputs");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListInputsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListInputsResult listInputsResult = (ListInputsResult)response.getAwsResponse();
            return listInputsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListOfferingsResult listOfferings(ListOfferingsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListOfferings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListOfferingsResult executeListOfferings(ListOfferingsRequest listOfferingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listOfferingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListOfferingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListOfferingsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listOfferingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListOfferings");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListOfferingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListOfferingsResult listOfferingsResult = (ListOfferingsResult)response.getAwsResponse();
            return listOfferingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListReservationsResult listReservations(ListReservationsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListReservations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListReservationsResult executeListReservations(ListReservationsRequest listReservationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listReservationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListReservationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListReservationsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listReservationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListReservations");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListReservationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListReservationsResult listReservationsResult = (ListReservationsResult)response.getAwsResponse();
            return listReservationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PurchaseOfferingResult purchaseOffering(PurchaseOfferingRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePurchaseOffering(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PurchaseOfferingResult executePurchaseOffering(PurchaseOfferingRequest purchaseOfferingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(purchaseOfferingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PurchaseOfferingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PurchaseOfferingRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(purchaseOfferingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PurchaseOffering");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new PurchaseOfferingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PurchaseOfferingResult purchaseOfferingResult = (PurchaseOfferingResult)response.getAwsResponse();
            return purchaseOfferingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartChannelResult startChannel(StartChannelRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeStartChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartChannelResult executeStartChannel(StartChannelRequest startChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartChannelRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(startChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "StartChannel");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new StartChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartChannelResult startChannelResult = (StartChannelResult)response.getAwsResponse();
            return startChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopChannelResult stopChannel(StopChannelRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeStopChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopChannelResult executeStopChannel(StopChannelRequest stopChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopChannelRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(stopChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "StopChannel");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new StopChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopChannelResult stopChannelResult = (StopChannelResult)response.getAwsResponse();
            return stopChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateChannelResult updateChannel(UpdateChannelRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateChannelResult executeUpdateChannel(UpdateChannelRequest updateChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateChannelRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateChannel");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateChannelResult updateChannelResult = (UpdateChannelResult)response.getAwsResponse();
            return updateChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateInputResult updateInput(UpdateInputRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateInput(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateInputResult executeUpdateInput(UpdateInputRequest updateInputRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateInputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateInputRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateInputRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateInputRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateInput");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateInputResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateInputResult updateInputResult = (UpdateInputResult)response.getAwsResponse();
            return updateInputResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateInputSecurityGroupResult updateInputSecurityGroup(UpdateInputSecurityGroupRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateInputSecurityGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateInputSecurityGroupResult executeUpdateInputSecurityGroup(UpdateInputSecurityGroupRequest updateInputSecurityGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateInputSecurityGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateInputSecurityGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateInputSecurityGroupRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateInputSecurityGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "MediaLive");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateInputSecurityGroup");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateInputSecurityGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateInputSecurityGroupResult updateInputSecurityGroupResult = (UpdateInputSecurityGroupResult)response.getAwsResponse();
            return updateInputSecurityGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

