/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.WavSettings;

@SdkInternalApi
public class WavSettingsMarshaller {
    private static final MarshallingInfo<Integer> BITDEPTH_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitDepth").build();
    private static final MarshallingInfo<Integer> CHANNELS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channels").build();
    private static final MarshallingInfo<String> FORMAT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("format").build();
    private static final MarshallingInfo<Integer> SAMPLERATE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sampleRate").build();
    private static final WavSettingsMarshaller instance = new WavSettingsMarshaller();

    public static WavSettingsMarshaller getInstance() {
        return instance;
    }

    public void marshall(WavSettings wavSettings, ProtocolMarshaller protocolMarshaller) {
        if (wavSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(wavSettings.getBitDepth(), BITDEPTH_BINDING);
            protocolMarshaller.marshall(wavSettings.getChannels(), CHANNELS_BINDING);
            protocolMarshaller.marshall(wavSettings.getFormat(), FORMAT_BINDING);
            protocolMarshaller.marshall(wavSettings.getSampleRate(), SAMPLERATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

