/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.ReservationPlan;
import java.util.Date;

@SdkInternalApi
public class ReservationPlanMarshaller {
    private static final MarshallingInfo<String> COMMITMENT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("commitment").build();
    private static final MarshallingInfo<Date> EXPIRESAT_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("expiresAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> PURCHASEDAT_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("purchasedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> RENEWALTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("renewalType").build();
    private static final MarshallingInfo<Integer> RESERVEDSLOTS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("reservedSlots").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final ReservationPlanMarshaller instance = new ReservationPlanMarshaller();

    public static ReservationPlanMarshaller getInstance() {
        return instance;
    }

    public void marshall(ReservationPlan reservationPlan, ProtocolMarshaller protocolMarshaller) {
        if (reservationPlan == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(reservationPlan.getCommitment(), COMMITMENT_BINDING);
            protocolMarshaller.marshall(reservationPlan.getExpiresAt(), EXPIRESAT_BINDING);
            protocolMarshaller.marshall(reservationPlan.getPurchasedAt(), PURCHASEDAT_BINDING);
            protocolMarshaller.marshall(reservationPlan.getRenewalType(), RENEWALTYPE_BINDING);
            protocolMarshaller.marshall(reservationPlan.getReservedSlots(), RESERVEDSLOTS_BINDING);
            protocolMarshaller.marshall(reservationPlan.getStatus(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

