/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.AudioDescription;

@SdkInternalApi
public class AudioDescriptionMarshaller {
    private static final MarshallingInfo<StructuredPojo> AUDIONORMALIZATIONSETTINGS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioNormalizationSettings").build();
    private static final MarshallingInfo<String> AUDIOSOURCENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioSourceName").build();
    private static final MarshallingInfo<Integer> AUDIOTYPE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioType").build();
    private static final MarshallingInfo<String> AUDIOTYPECONTROL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioTypeControl").build();
    private static final MarshallingInfo<StructuredPojo> CODECSETTINGS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codecSettings").build();
    private static final MarshallingInfo<String> CUSTOMLANGUAGECODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customLanguageCode").build();
    private static final MarshallingInfo<String> LANGUAGECODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("languageCode").build();
    private static final MarshallingInfo<String> LANGUAGECODECONTROL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("languageCodeControl").build();
    private static final MarshallingInfo<StructuredPojo> REMIXSETTINGS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("remixSettings").build();
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streamName").build();
    private static final AudioDescriptionMarshaller instance = new AudioDescriptionMarshaller();

    public static AudioDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(AudioDescription audioDescription, ProtocolMarshaller protocolMarshaller) {
        if (audioDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(audioDescription.getAudioNormalizationSettings(), AUDIONORMALIZATIONSETTINGS_BINDING);
            protocolMarshaller.marshall(audioDescription.getAudioSourceName(), AUDIOSOURCENAME_BINDING);
            protocolMarshaller.marshall(audioDescription.getAudioType(), AUDIOTYPE_BINDING);
            protocolMarshaller.marshall(audioDescription.getAudioTypeControl(), AUDIOTYPECONTROL_BINDING);
            protocolMarshaller.marshall(audioDescription.getCodecSettings(), CODECSETTINGS_BINDING);
            protocolMarshaller.marshall(audioDescription.getCustomLanguageCode(), CUSTOMLANGUAGECODE_BINDING);
            protocolMarshaller.marshall(audioDescription.getLanguageCode(), LANGUAGECODE_BINDING);
            protocolMarshaller.marshall(audioDescription.getLanguageCodeControl(), LANGUAGECODECONTROL_BINDING);
            protocolMarshaller.marshall(audioDescription.getRemixSettings(), REMIXSETTINGS_BINDING);
            protocolMarshaller.marshall(audioDescription.getStreamName(), STREAMNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

