/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.CaptionSourceSettings;
import com.amazonaws.services.mediaconvert.model.LanguageCode;
import com.amazonaws.services.mediaconvert.model.transform.CaptionSelectorMarshaller;
import java.io.Serializable;

public class CaptionSelector
implements Serializable,
Cloneable,
StructuredPojo {
    private String customLanguageCode;
    private String languageCode;
    private CaptionSourceSettings sourceSettings;

    public void setCustomLanguageCode(String customLanguageCode) {
        this.customLanguageCode = customLanguageCode;
    }

    public String getCustomLanguageCode() {
        return this.customLanguageCode;
    }

    public CaptionSelector withCustomLanguageCode(String customLanguageCode) {
        this.setCustomLanguageCode(customLanguageCode);
        return this;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public CaptionSelector withLanguageCode(String languageCode) {
        this.setLanguageCode(languageCode);
        return this;
    }

    public CaptionSelector withLanguageCode(LanguageCode languageCode) {
        this.languageCode = languageCode.toString();
        return this;
    }

    public void setSourceSettings(CaptionSourceSettings sourceSettings) {
        this.sourceSettings = sourceSettings;
    }

    public CaptionSourceSettings getSourceSettings() {
        return this.sourceSettings;
    }

    public CaptionSelector withSourceSettings(CaptionSourceSettings sourceSettings) {
        this.setSourceSettings(sourceSettings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCustomLanguageCode() != null) {
            sb.append("CustomLanguageCode: ").append(this.getCustomLanguageCode()).append(",");
        }
        if (this.getLanguageCode() != null) {
            sb.append("LanguageCode: ").append(this.getLanguageCode()).append(",");
        }
        if (this.getSourceSettings() != null) {
            sb.append("SourceSettings: ").append(this.getSourceSettings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionSelector)) {
            return false;
        }
        CaptionSelector other = (CaptionSelector)obj;
        if (other.getCustomLanguageCode() == null ^ this.getCustomLanguageCode() == null) {
            return false;
        }
        if (other.getCustomLanguageCode() != null && !other.getCustomLanguageCode().equals(this.getCustomLanguageCode())) {
            return false;
        }
        if (other.getLanguageCode() == null ^ this.getLanguageCode() == null) {
            return false;
        }
        if (other.getLanguageCode() != null && !other.getLanguageCode().equals(this.getLanguageCode())) {
            return false;
        }
        if (other.getSourceSettings() == null ^ this.getSourceSettings() == null) {
            return false;
        }
        return other.getSourceSettings() == null || other.getSourceSettings().equals(this.getSourceSettings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCustomLanguageCode() == null ? 0 : this.getCustomLanguageCode().hashCode());
        hashCode = 31 * hashCode + (this.getLanguageCode() == null ? 0 : this.getLanguageCode().hashCode());
        hashCode = 31 * hashCode + (this.getSourceSettings() == null ? 0 : this.getSourceSettings().hashCode());
        return hashCode;
    }

    public CaptionSelector clone() {
        try {
            return (CaptionSelector)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CaptionSelectorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

