/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplaceentitlement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.marketplaceentitlement.model.Entitlement;
import java.util.Date;

@SdkInternalApi
public class EntitlementMarshaller {
    private static final MarshallingInfo<String> PRODUCTCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProductCode").build();
    private static final MarshallingInfo<String> DIMENSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Dimension").build();
    private static final MarshallingInfo<String> CUSTOMERIDENTIFIER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomerIdentifier").build();
    private static final MarshallingInfo<StructuredPojo> VALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final MarshallingInfo<Date> EXPIRATIONDATE_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpirationDate").timestampFormat("unixTimestamp").build();
    private static final EntitlementMarshaller instance = new EntitlementMarshaller();

    public static EntitlementMarshaller getInstance() {
        return instance;
    }

    public void marshall(Entitlement entitlement, ProtocolMarshaller protocolMarshaller) {
        if (entitlement == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(entitlement.getProductCode(), PRODUCTCODE_BINDING);
            protocolMarshaller.marshall(entitlement.getDimension(), DIMENSION_BINDING);
            protocolMarshaller.marshall(entitlement.getCustomerIdentifier(), CUSTOMERIDENTIFIER_BINDING);
            protocolMarshaller.marshall(entitlement.getValue(), VALUE_BINDING);
            protocolMarshaller.marshall(entitlement.getExpirationDate(), EXPIRATIONDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

