/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.macie.model.S3Resource;

@SdkInternalApi
public class S3ResourceMarshaller {
    private static final MarshallingInfo<String> BUCKETNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucketName").build();
    private static final MarshallingInfo<String> PREFIX_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("prefix").build();
    private static final S3ResourceMarshaller instance = new S3ResourceMarshaller();

    public static S3ResourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3Resource s3Resource, ProtocolMarshaller protocolMarshaller) {
        if (s3Resource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(s3Resource.getBucketName(), BUCKETNAME_BINDING);
            protocolMarshaller.marshall(s3Resource.getPrefix(), PREFIX_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

