/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.macie.model.S3ResourceClassification;

@SdkInternalApi
public class S3ResourceClassificationMarshaller {
    private static final MarshallingInfo<String> BUCKETNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucketName").build();
    private static final MarshallingInfo<String> PREFIX_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("prefix").build();
    private static final MarshallingInfo<StructuredPojo> CLASSIFICATIONTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("classificationType").build();
    private static final S3ResourceClassificationMarshaller instance = new S3ResourceClassificationMarshaller();

    public static S3ResourceClassificationMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3ResourceClassification s3ResourceClassification, ProtocolMarshaller protocolMarshaller) {
        if (s3ResourceClassification == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(s3ResourceClassification.getBucketName(), BUCKETNAME_BINDING);
            protocolMarshaller.marshall(s3ResourceClassification.getPrefix(), PREFIX_BINDING);
            protocolMarshaller.marshall(s3ResourceClassification.getClassificationType(), CLASSIFICATIONTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

