/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.macie.model.S3ResourceClassificationUpdate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateS3ResourcesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String memberAccountId;
    private List<S3ResourceClassificationUpdate> s3ResourcesUpdate;

    public void setMemberAccountId(String memberAccountId) {
        this.memberAccountId = memberAccountId;
    }

    public String getMemberAccountId() {
        return this.memberAccountId;
    }

    public UpdateS3ResourcesRequest withMemberAccountId(String memberAccountId) {
        this.setMemberAccountId(memberAccountId);
        return this;
    }

    public List<S3ResourceClassificationUpdate> getS3ResourcesUpdate() {
        return this.s3ResourcesUpdate;
    }

    public void setS3ResourcesUpdate(Collection<S3ResourceClassificationUpdate> s3ResourcesUpdate) {
        if (s3ResourcesUpdate == null) {
            this.s3ResourcesUpdate = null;
            return;
        }
        this.s3ResourcesUpdate = new ArrayList<S3ResourceClassificationUpdate>(s3ResourcesUpdate);
    }

    public UpdateS3ResourcesRequest withS3ResourcesUpdate(S3ResourceClassificationUpdate ... s3ResourcesUpdate) {
        if (this.s3ResourcesUpdate == null) {
            this.setS3ResourcesUpdate(new ArrayList<S3ResourceClassificationUpdate>(s3ResourcesUpdate.length));
        }
        for (S3ResourceClassificationUpdate ele : s3ResourcesUpdate) {
            this.s3ResourcesUpdate.add(ele);
        }
        return this;
    }

    public UpdateS3ResourcesRequest withS3ResourcesUpdate(Collection<S3ResourceClassificationUpdate> s3ResourcesUpdate) {
        this.setS3ResourcesUpdate(s3ResourcesUpdate);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMemberAccountId() != null) {
            sb.append("MemberAccountId: ").append(this.getMemberAccountId()).append(",");
        }
        if (this.getS3ResourcesUpdate() != null) {
            sb.append("S3ResourcesUpdate: ").append(this.getS3ResourcesUpdate());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateS3ResourcesRequest)) {
            return false;
        }
        UpdateS3ResourcesRequest other = (UpdateS3ResourcesRequest)obj;
        if (other.getMemberAccountId() == null ^ this.getMemberAccountId() == null) {
            return false;
        }
        if (other.getMemberAccountId() != null && !other.getMemberAccountId().equals(this.getMemberAccountId())) {
            return false;
        }
        if (other.getS3ResourcesUpdate() == null ^ this.getS3ResourcesUpdate() == null) {
            return false;
        }
        return other.getS3ResourcesUpdate() == null || other.getS3ResourcesUpdate().equals(this.getS3ResourcesUpdate());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMemberAccountId() == null ? 0 : this.getMemberAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getS3ResourcesUpdate() == null ? 0 : this.getS3ResourcesUpdate().hashCode());
        return hashCode;
    }

    @Override
    public UpdateS3ResourcesRequest clone() {
        return (UpdateS3ResourcesRequest)super.clone();
    }
}

