/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.StreamInfo;
import java.util.Date;

@SdkInternalApi
public class StreamInfoMarshaller {
    private static final MarshallingInfo<String> DEVICENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceName").build();
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamName").build();
    private static final MarshallingInfo<String> STREAMARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamARN").build();
    private static final MarshallingInfo<String> MEDIATYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MediaType").build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyId").build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Integer> DATARETENTIONINHOURS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataRetentionInHours").build();
    private static final StreamInfoMarshaller instance = new StreamInfoMarshaller();

    public static StreamInfoMarshaller getInstance() {
        return instance;
    }

    public void marshall(StreamInfo streamInfo, ProtocolMarshaller protocolMarshaller) {
        if (streamInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(streamInfo.getDeviceName(), DEVICENAME_BINDING);
            protocolMarshaller.marshall(streamInfo.getStreamName(), STREAMNAME_BINDING);
            protocolMarshaller.marshall(streamInfo.getStreamARN(), STREAMARN_BINDING);
            protocolMarshaller.marshall(streamInfo.getMediaType(), MEDIATYPE_BINDING);
            protocolMarshaller.marshall(streamInfo.getKmsKeyId(), KMSKEYID_BINDING);
            protocolMarshaller.marshall(streamInfo.getVersion(), VERSION_BINDING);
            protocolMarshaller.marshall(streamInfo.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(streamInfo.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall(streamInfo.getDataRetentionInHours(), DATARETENTIONINHOURS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

