/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo.model.transform;

import com.amazonaws.services.kinesisvideo.model.AckEvent;
import com.amazonaws.services.kinesisvideo.model.AckEventType;
import com.amazonaws.thirdparty.jackson.databind.JsonNode;

public class AckEventUnmarshaller {
    private static final String ACK_EVENT_TYPE = "EventType";
    private static final String FRAGMENT_TIMECODE = "FragmentTimecode";
    private static final String FRAGMENT_NUMBER = "FragmentNumber";
    private static final String ERROR_CODE = "ErrorCode";
    private static final String ERROR_ID = "ErrorId";

    public AckEvent unmarshall(JsonNode json) {
        return new AckEvent().withFragmentNumber(this.getTextField(json, FRAGMENT_NUMBER)).withFragmentTimecode(this.getLongField(json, FRAGMENT_TIMECODE)).withAckEventType(AckEventType.of(this.getTextField(json, ACK_EVENT_TYPE))).withErrorCode(this.getTextField(json, ERROR_CODE)).withErrorId(this.getIntegerField(json, ERROR_ID));
    }

    private String getTextField(JsonNode json, String fieldName) {
        if (!json.has(fieldName)) {
            return null;
        }
        return json.get(fieldName).asText();
    }

    private Long getLongField(JsonNode json, String fieldName) {
        if (!json.has(fieldName)) {
            return null;
        }
        return json.get(fieldName).longValue();
    }

    private Integer getIntegerField(JsonNode json, String fieldName) {
        if (!json.has(fieldName)) {
            return null;
        }
        return json.get(fieldName).intValue();
    }
}

