/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo.internal.netty.handler;

import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;
import com.amazonaws.thirdparty.io.netty.channel.Channel;
import com.amazonaws.thirdparty.io.netty.channel.ChannelHandler;
import com.amazonaws.thirdparty.io.netty.channel.ChannelInitializer;
import com.amazonaws.thirdparty.io.netty.channel.ChannelPipeline;
import com.amazonaws.thirdparty.io.netty.handler.codec.http.HttpClientCodec;
import com.amazonaws.thirdparty.io.netty.handler.logging.LoggingHandler;
import com.amazonaws.thirdparty.io.netty.handler.ssl.SslContext;
import com.amazonaws.thirdparty.io.netty.handler.stream.ChunkedWriteHandler;
import java.util.ArrayList;
import java.util.List;

public class PutMediaHandlerInitializer
extends ChannelInitializer<Channel> {
    private static final Log log = LogFactory.getLog(PutMediaHandlerInitializer.class);
    private final SslContext sslContext;
    private final List<ChannelHandler> handlers;

    public PutMediaHandlerInitializer(SslContext sslContext, List<ChannelHandler> handlers) {
        this.sslContext = sslContext;
        this.handlers = new ArrayList<ChannelHandler>(handlers);
    }

    @Override
    public void initChannel(Channel channel) throws Exception {
        ChannelPipeline pipeline = channel.pipeline();
        if (log.isDebugEnabled()) {
            pipeline.addLast(new LoggingHandler());
        }
        if (this.sslContext != null) {
            pipeline.addLast("ssl", (ChannelHandler)this.sslContext.newHandler(channel.alloc()));
        }
        pipeline.addLast("http-codec", (ChannelHandler)new HttpClientCodec());
        for (ChannelHandler handler : this.handlers) {
            pipeline.addLast(handler);
        }
        pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
    }
}

