/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo;

import com.amazonaws.AbortedException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.RequestClientOptions;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.Signer;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoMediaClient;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoPutMedia;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoPutMediaClientBuilder;
import com.amazonaws.services.kinesisvideo.PutMediaAckResponseHandler;
import com.amazonaws.services.kinesisvideo.PutMediaResponseHandler;
import com.amazonaws.services.kinesisvideo.internal.auth.PutMediaAWS4Signer;
import com.amazonaws.services.kinesisvideo.internal.netty.handler.DeliverAckHandler;
import com.amazonaws.services.kinesisvideo.internal.netty.handler.ErrorUnmarshallingHandler;
import com.amazonaws.services.kinesisvideo.internal.netty.handler.PutMediaDecoder;
import com.amazonaws.services.kinesisvideo.internal.netty.handler.PutMediaHandlerInitializer;
import com.amazonaws.services.kinesisvideo.internal.netty.util.RequestAdapter;
import com.amazonaws.services.kinesisvideo.model.PutMediaRequest;
import com.amazonaws.services.kinesisvideo.model.transform.PutMediaRequestProtocolMarshaller;
import com.amazonaws.thirdparty.io.netty.bootstrap.Bootstrap;
import com.amazonaws.thirdparty.io.netty.channel.Channel;
import com.amazonaws.thirdparty.io.netty.channel.ChannelFuture;
import com.amazonaws.thirdparty.io.netty.channel.ChannelHandler;
import com.amazonaws.thirdparty.io.netty.channel.ChannelOption;
import com.amazonaws.thirdparty.io.netty.channel.EventLoopGroup;
import com.amazonaws.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import com.amazonaws.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import com.amazonaws.thirdparty.io.netty.handler.codec.http.HttpChunkedInput;
import com.amazonaws.thirdparty.io.netty.handler.codec.http.HttpHeaderNames;
import com.amazonaws.thirdparty.io.netty.handler.codec.http.HttpHeaderValues;
import com.amazonaws.thirdparty.io.netty.handler.codec.http.HttpRequest;
import com.amazonaws.thirdparty.io.netty.handler.ssl.SslContext;
import com.amazonaws.thirdparty.io.netty.handler.ssl.SslContextBuilder;
import com.amazonaws.thirdparty.io.netty.handler.stream.ChunkedStream;
import com.amazonaws.thirdparty.io.netty.util.concurrent.Future;
import com.amazonaws.thirdparty.io.netty.util.concurrent.GenericFutureListener;
import com.amazonaws.util.CredentialUtils;
import com.amazonaws.util.RuntimeHttpUtils;
import com.amazonaws.util.VersionInfoUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;

public final class AmazonKinesisVideoPutMediaClient
implements AmazonKinesisVideoPutMedia {
    private static final String USER_AGENT = "NettyPutMedia/" + VersionInfoUtils.getVersion();
    private final Signer signer;
    private final AWSCredentialsProvider credentialsProvider;
    private final URI endpoint;
    private final int connectionTimeoutInMillis;
    private final EventLoopGroup group;
    private final SdkJsonProtocolFactory protocolFactory = AmazonKinesisVideoMediaClient.getProtocolFactory();

    AmazonKinesisVideoPutMediaClient(String region, AWSCredentialsProvider credentialsProvider, int connectionTimeoutInMillis, URI endpoint, Integer numberOfThreads) {
        this.signer = new PutMediaAWS4Signer(region);
        this.credentialsProvider = credentialsProvider;
        this.connectionTimeoutInMillis = connectionTimeoutInMillis;
        this.endpoint = endpoint;
        this.group = numberOfThreads == null ? new NioEventLoopGroup() : new NioEventLoopGroup(numberOfThreads);
    }

    @Override
    public void putMedia(PutMediaRequest request, PutMediaAckResponseHandler responseHandler) {
        this.doPutMedia(request.clone(), responseHandler, Arrays.asList(new PutMediaDecoder(), new DeliverAckHandler(responseHandler)));
    }

    private void doPutMedia(PutMediaRequest request, PutMediaResponseHandler responseHandler, List<ChannelHandler> requestHandlers) {
        request.getRequestClientOptions().appendUserAgent(USER_AGENT);
        Request<PutMediaRequest> marshalled = this.marshall(request);
        this.applyUserAgent(request, marshalled);
        this.signer.sign(marshalled, this.resolveCredentials(request));
        try {
            Bootstrap b = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channel(NioSocketChannel.class)).remoteAddress(marshalled.getEndpoint().getHost(), this.getPort(marshalled.getEndpoint())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.connectionTimeoutInMillis)).handler(new PutMediaHandlerInitializer(this.getSslContext(marshalled.getEndpoint()), this.createHandlers(responseHandler, marshalled, requestHandlers)));
            this.invoke(marshalled, b, responseHandler);
        }
        catch (InterruptedException e) {
            throw this.handleInterruptedException(e);
        }
    }

    private List<ChannelHandler> createHandlers(PutMediaResponseHandler responseHandler, Request<PutMediaRequest> marshalled, List<ChannelHandler> requestHandlers) {
        ArrayList<ChannelHandler> handlers = new ArrayList<ChannelHandler>(requestHandlers);
        handlers.add(new ErrorUnmarshallingHandler(responseHandler, this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata()), marshalled));
        return handlers;
    }

    private void applyUserAgent(PutMediaRequest request, Request<PutMediaRequest> marshalled) {
        if (!marshalled.getHeaders().containsKey("User-Agent")) {
            marshalled.addHeader("User-Agent", RuntimeHttpUtils.getUserAgent(new ClientConfiguration(), request.getRequestClientOptions().getClientMarker(RequestClientOptions.Marker.USER_AGENT)));
        }
    }

    private RuntimeException handleInterruptedException(InterruptedException e) {
        Thread.currentThread().interrupt();
        return new AbortedException("Interrupted while making PutMedia request", e);
    }

    private int getPort(URI endpoint) {
        if (endpoint.getPort() != -1) {
            return endpoint.getPort();
        }
        if ("https".equals(endpoint.getScheme())) {
            return 443;
        }
        return 80;
    }

    private Request<PutMediaRequest> marshall(PutMediaRequest request) {
        Request<PutMediaRequest> marshalled = new PutMediaRequestProtocolMarshaller(this.protocolFactory).marshall(request);
        marshalled.setEndpoint(this.endpoint);
        marshalled.addHeader(HttpHeaderNames.TRANSFER_ENCODING.toString(), HttpHeaderValues.CHUNKED.toString());
        return marshalled;
    }

    private AWSCredentials resolveCredentials(PutMediaRequest request) {
        AWSCredentials resolvedCredentials;
        AWSCredentialsProvider resolvedProvider = CredentialUtils.getCredentialsProvider(request, this.credentialsProvider);
        AWSCredentials aWSCredentials = resolvedCredentials = resolvedProvider == null ? null : resolvedProvider.getCredentials();
        if (resolvedCredentials == null) {
            throw new SdkClientException("Credentials must be provided via the builder or present in the environment. See http://docs.aws.amazon.com/sdk-for-java/v1/developer-guide/credentials.html");
        }
        return resolvedCredentials;
    }

    private SslContext getSslContext(URI uri) {
        if (!"https".equalsIgnoreCase(uri.getScheme())) {
            return null;
        }
        try {
            return SslContextBuilder.forClient().build();
        }
        catch (SSLException e) {
            throw new SdkClientException("Could not create SSL context", e);
        }
    }

    private void invoke(final Request<?> marshalledRequest, Bootstrap b, final PutMediaResponseHandler responseHandler) throws InterruptedException {
        b.connect().addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<ChannelFuture>(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                try {
                    Channel channel = future.channel();
                    HttpRequest request = RequestAdapter.adapt(marshalledRequest);
                    channel.writeAndFlush(request);
                    channel.writeAndFlush(new HttpChunkedInput(new ChunkedStream(marshalledRequest.getContent())));
                }
                catch (Exception e) {
                    responseHandler.onFailure(e);
                }
            }
        });
    }

    @Override
    public void close() {
        final CountDownLatch latch = new CountDownLatch(1);
        this.group.shutdownGracefully().addListener(new GenericFutureListener(){

            public void operationComplete(Future future) throws Exception {
                latch.countDown();
            }
        });
        try {
            latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw this.handleInterruptedException(e);
        }
    }

    public static AmazonKinesisVideoPutMediaClientBuilder builder() {
        return new AmazonKinesisVideoPutMediaClientBuilder();
    }
}

