/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoArchivedMediaAsync;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoArchivedMediaAsyncClientBuilder;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoArchivedMediaClient;
import com.amazonaws.services.kinesisvideo.model.GetHLSStreamingSessionURLRequest;
import com.amazonaws.services.kinesisvideo.model.GetHLSStreamingSessionURLResult;
import com.amazonaws.services.kinesisvideo.model.GetMediaForFragmentListRequest;
import com.amazonaws.services.kinesisvideo.model.GetMediaForFragmentListResult;
import com.amazonaws.services.kinesisvideo.model.ListFragmentsRequest;
import com.amazonaws.services.kinesisvideo.model.ListFragmentsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonKinesisVideoArchivedMediaAsyncClient
extends AmazonKinesisVideoArchivedMediaClient
implements AmazonKinesisVideoArchivedMediaAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonKinesisVideoArchivedMediaAsyncClientBuilder asyncBuilder() {
        return AmazonKinesisVideoArchivedMediaAsyncClientBuilder.standard();
    }

    AmazonKinesisVideoArchivedMediaAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<GetHLSStreamingSessionURLResult> getHLSStreamingSessionURLAsync(GetHLSStreamingSessionURLRequest request) {
        return this.getHLSStreamingSessionURLAsync(request, null);
    }

    @Override
    public Future<GetHLSStreamingSessionURLResult> getHLSStreamingSessionURLAsync(GetHLSStreamingSessionURLRequest request, final AsyncHandler<GetHLSStreamingSessionURLRequest, GetHLSStreamingSessionURLResult> asyncHandler) {
        final GetHLSStreamingSessionURLRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetHLSStreamingSessionURLResult>(){

            @Override
            public GetHLSStreamingSessionURLResult call() throws Exception {
                GetHLSStreamingSessionURLResult result = null;
                try {
                    result = AmazonKinesisVideoArchivedMediaAsyncClient.this.executeGetHLSStreamingSessionURL(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMediaForFragmentListResult> getMediaForFragmentListAsync(GetMediaForFragmentListRequest request) {
        return this.getMediaForFragmentListAsync(request, null);
    }

    @Override
    public Future<GetMediaForFragmentListResult> getMediaForFragmentListAsync(GetMediaForFragmentListRequest request, final AsyncHandler<GetMediaForFragmentListRequest, GetMediaForFragmentListResult> asyncHandler) {
        final GetMediaForFragmentListRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMediaForFragmentListResult>(){

            @Override
            public GetMediaForFragmentListResult call() throws Exception {
                GetMediaForFragmentListResult result = null;
                try {
                    result = AmazonKinesisVideoArchivedMediaAsyncClient.this.executeGetMediaForFragmentList(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFragmentsResult> listFragmentsAsync(ListFragmentsRequest request) {
        return this.listFragmentsAsync(request, null);
    }

    @Override
    public Future<ListFragmentsResult> listFragmentsAsync(ListFragmentsRequest request, final AsyncHandler<ListFragmentsRequest, ListFragmentsResult> asyncHandler) {
        final ListFragmentsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListFragmentsResult>(){

            @Override
            public ListFragmentsResult call() throws Exception {
                ListFragmentsResult result = null;
                try {
                    result = AmazonKinesisVideoArchivedMediaAsyncClient.this.executeListFragments(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

