/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotjobsdataplane;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iotjobsdataplane.AWSIoTJobsDataPlane;
import com.amazonaws.services.iotjobsdataplane.AWSIoTJobsDataPlaneClientBuilder;
import com.amazonaws.services.iotjobsdataplane.model.AWSIoTJobsDataPlaneException;
import com.amazonaws.services.iotjobsdataplane.model.CertificateValidationException;
import com.amazonaws.services.iotjobsdataplane.model.DescribeJobExecutionRequest;
import com.amazonaws.services.iotjobsdataplane.model.DescribeJobExecutionResult;
import com.amazonaws.services.iotjobsdataplane.model.GetPendingJobExecutionsRequest;
import com.amazonaws.services.iotjobsdataplane.model.GetPendingJobExecutionsResult;
import com.amazonaws.services.iotjobsdataplane.model.InvalidRequestException;
import com.amazonaws.services.iotjobsdataplane.model.InvalidStateTransitionException;
import com.amazonaws.services.iotjobsdataplane.model.ResourceNotFoundException;
import com.amazonaws.services.iotjobsdataplane.model.ServiceUnavailableException;
import com.amazonaws.services.iotjobsdataplane.model.StartNextPendingJobExecutionRequest;
import com.amazonaws.services.iotjobsdataplane.model.StartNextPendingJobExecutionResult;
import com.amazonaws.services.iotjobsdataplane.model.TerminalStateException;
import com.amazonaws.services.iotjobsdataplane.model.ThrottlingException;
import com.amazonaws.services.iotjobsdataplane.model.UpdateJobExecutionRequest;
import com.amazonaws.services.iotjobsdataplane.model.UpdateJobExecutionResult;
import com.amazonaws.services.iotjobsdataplane.model.transform.DescribeJobExecutionRequestProtocolMarshaller;
import com.amazonaws.services.iotjobsdataplane.model.transform.DescribeJobExecutionResultJsonUnmarshaller;
import com.amazonaws.services.iotjobsdataplane.model.transform.GetPendingJobExecutionsRequestProtocolMarshaller;
import com.amazonaws.services.iotjobsdataplane.model.transform.GetPendingJobExecutionsResultJsonUnmarshaller;
import com.amazonaws.services.iotjobsdataplane.model.transform.StartNextPendingJobExecutionRequestProtocolMarshaller;
import com.amazonaws.services.iotjobsdataplane.model.transform.StartNextPendingJobExecutionResultJsonUnmarshaller;
import com.amazonaws.services.iotjobsdataplane.model.transform.UpdateJobExecutionRequestProtocolMarshaller;
import com.amazonaws.services.iotjobsdataplane.model.transform.UpdateJobExecutionResultJsonUnmarshaller;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;

@ThreadSafe
public class AWSIoTJobsDataPlaneClient
extends AmazonWebServiceClient
implements AWSIoTJobsDataPlane {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSIoTJobsDataPlane.class);
    private static final String DEFAULT_SIGNING_NAME = "iot-jobs-data";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidStateTransitionException").withModeledClass(InvalidStateTransitionException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TerminalStateException").withModeledClass(TerminalStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withModeledClass(ServiceUnavailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withModeledClass(InvalidRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withModeledClass(ThrottlingException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CertificateValidationException").withModeledClass(CertificateValidationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).withBaseServiceExceptionClass(AWSIoTJobsDataPlaneException.class));

    public static AWSIoTJobsDataPlaneClientBuilder builder() {
        return AWSIoTJobsDataPlaneClientBuilder.standard();
    }

    AWSIoTJobsDataPlaneClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    AWSIoTJobsDataPlaneClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("data.jobs.iot");
        this.setEndpoint("data.jobs.iot.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/iotjobsdataplane/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/iotjobsdataplane/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public DescribeJobExecutionResult describeJobExecution(DescribeJobExecutionRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeJobExecution(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeJobExecutionResult executeDescribeJobExecution(DescribeJobExecutionRequest describeJobExecutionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeJobExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeJobExecutionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeJobExecutionRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeJobExecutionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "IoT Jobs Data Plane");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeJobExecution");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeJobExecutionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeJobExecutionResult describeJobExecutionResult = (DescribeJobExecutionResult)response.getAwsResponse();
            return describeJobExecutionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetPendingJobExecutionsResult getPendingJobExecutions(GetPendingJobExecutionsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetPendingJobExecutions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetPendingJobExecutionsResult executeGetPendingJobExecutions(GetPendingJobExecutionsRequest getPendingJobExecutionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPendingJobExecutionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPendingJobExecutionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPendingJobExecutionsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getPendingJobExecutionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "IoT Jobs Data Plane");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetPendingJobExecutions");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetPendingJobExecutionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetPendingJobExecutionsResult getPendingJobExecutionsResult = (GetPendingJobExecutionsResult)response.getAwsResponse();
            return getPendingJobExecutionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartNextPendingJobExecutionResult startNextPendingJobExecution(StartNextPendingJobExecutionRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeStartNextPendingJobExecution(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartNextPendingJobExecutionResult executeStartNextPendingJobExecution(StartNextPendingJobExecutionRequest startNextPendingJobExecutionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startNextPendingJobExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartNextPendingJobExecutionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartNextPendingJobExecutionRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(startNextPendingJobExecutionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "IoT Jobs Data Plane");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "StartNextPendingJobExecution");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new StartNextPendingJobExecutionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartNextPendingJobExecutionResult startNextPendingJobExecutionResult = (StartNextPendingJobExecutionResult)response.getAwsResponse();
            return startNextPendingJobExecutionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateJobExecutionResult updateJobExecution(UpdateJobExecutionRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateJobExecution(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateJobExecutionResult executeUpdateJobExecution(UpdateJobExecutionRequest updateJobExecutionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateJobExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateJobExecutionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateJobExecutionRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateJobExecutionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "IoT Jobs Data Plane");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateJobExecution");
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateJobExecutionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateJobExecutionResult updateJobExecutionResult = (UpdateJobExecutionResult)response.getAwsResponse();
            return updateJobExecutionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

