/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotanalytics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.iotanalytics.model.DatasetSummary;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class DatasetSummaryMarshaller {
    private static final MarshallingInfo<String> DATASETNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("datasetName").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTUPDATETIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<List> TRIGGERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("triggers").build();
    private static final MarshallingInfo<List> ACTIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actions").build();
    private static final DatasetSummaryMarshaller instance = new DatasetSummaryMarshaller();

    public static DatasetSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(DatasetSummary datasetSummary, ProtocolMarshaller protocolMarshaller) {
        if (datasetSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(datasetSummary.getDatasetName(), DATASETNAME_BINDING);
            protocolMarshaller.marshall(datasetSummary.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(datasetSummary.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall(datasetSummary.getLastUpdateTime(), LASTUPDATETIME_BINDING);
            protocolMarshaller.marshall(datasetSummary.getTriggers(), TRIGGERS_BINDING);
            protocolMarshaller.marshall(datasetSummary.getActions(), ACTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

