/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotanalytics.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotanalytics.model.QueryFilter;
import com.amazonaws.services.iotanalytics.model.transform.SqlQueryDatasetActionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SqlQueryDatasetAction
implements Serializable,
Cloneable,
StructuredPojo {
    private String sqlQuery;
    private List<QueryFilter> filters;

    public void setSqlQuery(String sqlQuery) {
        this.sqlQuery = sqlQuery;
    }

    public String getSqlQuery() {
        return this.sqlQuery;
    }

    public SqlQueryDatasetAction withSqlQuery(String sqlQuery) {
        this.setSqlQuery(sqlQuery);
        return this;
    }

    public List<QueryFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<QueryFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<QueryFilter>(filters);
    }

    public SqlQueryDatasetAction withFilters(QueryFilter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<QueryFilter>(filters.length));
        }
        for (QueryFilter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public SqlQueryDatasetAction withFilters(Collection<QueryFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSqlQuery() != null) {
            sb.append("SqlQuery: ").append(this.getSqlQuery()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlQueryDatasetAction)) {
            return false;
        }
        SqlQueryDatasetAction other = (SqlQueryDatasetAction)obj;
        if (other.getSqlQuery() == null ^ this.getSqlQuery() == null) {
            return false;
        }
        if (other.getSqlQuery() != null && !other.getSqlQuery().equals(this.getSqlQuery())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        return other.getFilters() == null || other.getFilters().equals(this.getFilters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSqlQuery() == null ? 0 : this.getSqlQuery().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        return hashCode;
    }

    public SqlQueryDatasetAction clone() {
        try {
            return (SqlQueryDatasetAction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SqlQueryDatasetActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

