/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotanalytics.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iotanalytics.model.PipelineActivity;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RunPipelineActivityRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private PipelineActivity pipelineActivity;
    private List<ByteBuffer> payloads;

    public void setPipelineActivity(PipelineActivity pipelineActivity) {
        this.pipelineActivity = pipelineActivity;
    }

    public PipelineActivity getPipelineActivity() {
        return this.pipelineActivity;
    }

    public RunPipelineActivityRequest withPipelineActivity(PipelineActivity pipelineActivity) {
        this.setPipelineActivity(pipelineActivity);
        return this;
    }

    public List<ByteBuffer> getPayloads() {
        return this.payloads;
    }

    public void setPayloads(Collection<ByteBuffer> payloads) {
        if (payloads == null) {
            this.payloads = null;
            return;
        }
        this.payloads = new ArrayList<ByteBuffer>(payloads);
    }

    public RunPipelineActivityRequest withPayloads(ByteBuffer ... payloads) {
        if (this.payloads == null) {
            this.setPayloads(new ArrayList<ByteBuffer>(payloads.length));
        }
        for (ByteBuffer ele : payloads) {
            this.payloads.add(ele);
        }
        return this;
    }

    public RunPipelineActivityRequest withPayloads(Collection<ByteBuffer> payloads) {
        this.setPayloads(payloads);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPipelineActivity() != null) {
            sb.append("PipelineActivity: ").append(this.getPipelineActivity()).append(",");
        }
        if (this.getPayloads() != null) {
            sb.append("Payloads: ").append(this.getPayloads());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunPipelineActivityRequest)) {
            return false;
        }
        RunPipelineActivityRequest other = (RunPipelineActivityRequest)obj;
        if (other.getPipelineActivity() == null ^ this.getPipelineActivity() == null) {
            return false;
        }
        if (other.getPipelineActivity() != null && !other.getPipelineActivity().equals(this.getPipelineActivity())) {
            return false;
        }
        if (other.getPayloads() == null ^ this.getPayloads() == null) {
            return false;
        }
        return other.getPayloads() == null || other.getPayloads().equals(this.getPayloads());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPipelineActivity() == null ? 0 : this.getPipelineActivity().hashCode());
        hashCode = 31 * hashCode + (this.getPayloads() == null ? 0 : this.getPayloads().hashCode());
        return hashCode;
    }

    @Override
    public RunPipelineActivityRequest clone() {
        return (RunPipelineActivityRequest)super.clone();
    }
}

