/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotanalytics.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotanalytics.model.ComputeType;
import com.amazonaws.services.iotanalytics.model.transform.ResourceConfigurationMarshaller;
import java.io.Serializable;

public class ResourceConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String computeType;
    private Integer volumeSizeInGB;

    public void setComputeType(String computeType) {
        this.computeType = computeType;
    }

    public String getComputeType() {
        return this.computeType;
    }

    public ResourceConfiguration withComputeType(String computeType) {
        this.setComputeType(computeType);
        return this;
    }

    public ResourceConfiguration withComputeType(ComputeType computeType) {
        this.computeType = computeType.toString();
        return this;
    }

    public void setVolumeSizeInGB(Integer volumeSizeInGB) {
        this.volumeSizeInGB = volumeSizeInGB;
    }

    public Integer getVolumeSizeInGB() {
        return this.volumeSizeInGB;
    }

    public ResourceConfiguration withVolumeSizeInGB(Integer volumeSizeInGB) {
        this.setVolumeSizeInGB(volumeSizeInGB);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getComputeType() != null) {
            sb.append("ComputeType: ").append(this.getComputeType()).append(",");
        }
        if (this.getVolumeSizeInGB() != null) {
            sb.append("VolumeSizeInGB: ").append(this.getVolumeSizeInGB());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceConfiguration)) {
            return false;
        }
        ResourceConfiguration other = (ResourceConfiguration)obj;
        if (other.getComputeType() == null ^ this.getComputeType() == null) {
            return false;
        }
        if (other.getComputeType() != null && !other.getComputeType().equals(this.getComputeType())) {
            return false;
        }
        if (other.getVolumeSizeInGB() == null ^ this.getVolumeSizeInGB() == null) {
            return false;
        }
        return other.getVolumeSizeInGB() == null || other.getVolumeSizeInGB().equals(this.getVolumeSizeInGB());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getComputeType() == null ? 0 : this.getComputeType().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeSizeInGB() == null ? 0 : this.getVolumeSizeInGB().hashCode());
        return hashCode;
    }

    public ResourceConfiguration clone() {
        try {
            return (ResourceConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

