/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotanalytics.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iotanalytics.model.Message;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchPutMessageRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String channelName;
    private List<Message> messages;

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public BatchPutMessageRequest withChannelName(String channelName) {
        this.setChannelName(channelName);
        return this;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(Collection<Message> messages) {
        if (messages == null) {
            this.messages = null;
            return;
        }
        this.messages = new ArrayList<Message>(messages);
    }

    public BatchPutMessageRequest withMessages(Message ... messages) {
        if (this.messages == null) {
            this.setMessages(new ArrayList<Message>(messages.length));
        }
        for (Message ele : messages) {
            this.messages.add(ele);
        }
        return this;
    }

    public BatchPutMessageRequest withMessages(Collection<Message> messages) {
        this.setMessages(messages);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getChannelName() != null) {
            sb.append("ChannelName: ").append(this.getChannelName()).append(",");
        }
        if (this.getMessages() != null) {
            sb.append("Messages: ").append(this.getMessages());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutMessageRequest)) {
            return false;
        }
        BatchPutMessageRequest other = (BatchPutMessageRequest)obj;
        if (other.getChannelName() == null ^ this.getChannelName() == null) {
            return false;
        }
        if (other.getChannelName() != null && !other.getChannelName().equals(this.getChannelName())) {
            return false;
        }
        if (other.getMessages() == null ^ this.getMessages() == null) {
            return false;
        }
        return other.getMessages() == null || other.getMessages().equals(this.getMessages());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getChannelName() == null ? 0 : this.getChannelName().hashCode());
        hashCode = 31 * hashCode + (this.getMessages() == null ? 0 : this.getMessages().hashCode());
        return hashCode;
    }

    @Override
    public BatchPutMessageRequest clone() {
        return (BatchPutMessageRequest)super.clone();
    }
}

