/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotanalytics.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotanalytics.model.transform.AddAttributesActivityMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AddAttributesActivity
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private Map<String, String> attributes;
    private String next;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public AddAttributesActivity withName(String name) {
        this.setName(name);
        return this;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public AddAttributesActivity withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public AddAttributesActivity addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, String>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public AddAttributesActivity clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public void setNext(String next) {
        this.next = next;
    }

    public String getNext() {
        return this.next;
    }

    public AddAttributesActivity withNext(String next) {
        this.setNext(next);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getNext() != null) {
            sb.append("Next: ").append(this.getNext());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddAttributesActivity)) {
            return false;
        }
        AddAttributesActivity other = (AddAttributesActivity)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getNext() == null ^ this.getNext() == null) {
            return false;
        }
        return other.getNext() == null || other.getNext().equals(this.getNext());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getNext() == null ? 0 : this.getNext().hashCode());
        return hashCode;
    }

    public AddAttributesActivity clone() {
        try {
            return (AddAttributesActivity)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AddAttributesActivityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

