/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot1clickdevices.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.iot1clickdevices.model.DeviceMethod;

@SdkInternalApi
public class DeviceMethodMarshaller {
    private static final MarshallingInfo<String> DEVICETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deviceType").build();
    private static final MarshallingInfo<String> METHODNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("methodName").build();
    private static final DeviceMethodMarshaller instance = new DeviceMethodMarshaller();

    public static DeviceMethodMarshaller getInstance() {
        return instance;
    }

    public void marshall(DeviceMethod deviceMethod, ProtocolMarshaller protocolMarshaller) {
        if (deviceMethod == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(deviceMethod.getDeviceType(), DEVICETYPE_BINDING);
            protocolMarshaller.marshall(deviceMethod.getMethodName(), METHODNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

